/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Date;
import org.w3c.dom.Element;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

public class UserWithStatus
extends User {
    private String profileBackgroundColor;
    private String profileTextColor;
    private String profileLinkColor;
    private String profileSidebarFillColor;
    private String profileSidebarBorderColor;
    private int friendsCount;
    private int favouritesCount;
    private int statusesCount;
    private Date statusCreatedAt;
    private long statusId = -1L;
    private String statusText = null;
    private String statusSource = null;
    private boolean statusTruncated = false;
    private long statusInReplyToStatusId = -1L;
    private int statusInReplyToUserId = -1;
    private boolean statusFavorited = false;
    private String statusInReplyToScreenName = null;
    private static final long serialVersionUID = -3338496376247577523L;

    public UserWithStatus(Element elem, Twitter twitter) throws TwitterException {
        super(elem, twitter);
        this.profileBackgroundColor = this.getChildText("profile_background_color", elem);
        this.profileTextColor = this.getChildText("profile_text_color", elem);
        this.profileLinkColor = this.getChildText("profile_link_color", elem);
        this.profileSidebarFillColor = this.getChildText("profile_sidebar_fill_color", elem);
        this.profileSidebarBorderColor = this.getChildText("profile_sidebar_border_color", elem);
        this.friendsCount = this.getChildInt("friends_count", elem);
        this.favouritesCount = this.getChildInt("favourites_count", elem);
        this.statusesCount = this.getChildInt("statuses_count", elem);
        if (!this.isProtected()) {
            Element status = (Element)elem.getElementsByTagName("status").item(0);
            this.statusCreatedAt = this.getChildDate("created_at", status);
            this.statusId = Long.valueOf(status.getElementsByTagName("id").item(0).getTextContent());
            this.statusText = this.getChildText("text", status);
            this.statusSource = this.getChildText("source", status);
            this.statusTruncated = this.getChildBoolean("truncated", status);
            this.statusInReplyToStatusId = this.getChildLong("in_reply_to_status_id", status);
            this.statusInReplyToUserId = this.getChildInt("in_reply_to_user_id", status);
            this.statusFavorited = this.getChildBoolean("favorited", status);
            this.statusInReplyToScreenName = this.getChildText("in_reply_to_screen_name", status);
        }
    }

    public String getProfileBackgroundColor() {
        return this.profileBackgroundColor;
    }

    public String getProfileTextColor() {
        return this.profileTextColor;
    }

    public String getProfileLinkColor() {
        return this.profileLinkColor;
    }

    public String getProfileSidebarFillColor() {
        return this.profileSidebarFillColor;
    }

    public String getProfileSidebarBorderColor() {
        return this.profileSidebarBorderColor;
    }

    public int getFriendsCount() {
        return this.friendsCount;
    }

    public int getFavouritesCount() {
        return this.favouritesCount;
    }

    public int getStatusesCount() {
        return this.statusesCount;
    }

    public Date getStatusCreatedAt() {
        return this.statusCreatedAt;
    }

    public long getStatusId() {
        return this.statusId;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getStatusSource() {
        return this.statusSource;
    }

    public boolean isStatusTruncated() {
        return this.statusTruncated;
    }

    public long getStatusInReplyToStatusId() {
        return this.statusInReplyToStatusId;
    }

    public int getStatusInReplyToUserId() {
        return this.statusInReplyToUserId;
    }

    public boolean isStatusFavorited() {
        return this.statusFavorited;
    }

    public String getStatusInReplyToScreenName() {
        return -1 != this.statusInReplyToUserId ? this.statusInReplyToScreenName : null;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).getId() == this.getId();
    }

    public String toString() {
        return "UserWithStatus{profileBackgroundColor='" + this.profileBackgroundColor + '\'' + ", profileTextColor='" + this.profileTextColor + '\'' + ", profileLinkColor='" + this.profileLinkColor + '\'' + ", profileSidebarFillColor='" + this.profileSidebarFillColor + '\'' + ", profileSidebarBorderColor='" + this.profileSidebarBorderColor + '\'' + ", friendsCount=" + this.friendsCount + ", favouritesCount=" + this.favouritesCount + ", statusesCount=" + this.statusesCount + ", statusCreatedAt=" + this.statusCreatedAt + ", statusId=" + this.statusId + ", statusText='" + this.statusText + '\'' + ", statusSource='" + this.statusSource + '\'' + ", statusTruncated=" + this.statusTruncated + ", statusInReplyToStatusId=" + this.statusInReplyToStatusId + ", statusInReplyToUserId=" + this.statusInReplyToUserId + ", statusFavorited=" + this.statusFavorited + ", statusInReplyToScreenName='" + this.statusInReplyToScreenName + '\'' + '}';
    }
}

