/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.DirectMessage;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends TwitterResponse
implements Serializable {
    static final String[] POSSIBLE_ROOT_NAMES = new String[]{"user", "sender", "recipient"};
    private Twitter twitter;
    private int id;
    private String name;
    private String screenName;
    private String location;
    private String description;
    private String profileImageUrl;
    private String url;
    private boolean isProtected;
    private int followersCount;
    private static final long serialVersionUID = 3037057798600246529L;

    User(Element elem, Twitter twitter) throws TwitterException {
        this.twitter = twitter;
        this.ensureRootNodeNameIs(POSSIBLE_ROOT_NAMES, elem);
        this.id = this.getChildInt("id", elem);
        this.name = this.getChildText("name", elem);
        this.screenName = this.getChildText("screen_name", elem);
        this.location = this.getChildText("location", elem);
        this.description = this.getChildText("description", elem);
        this.profileImageUrl = this.getChildText("profile_image_url", elem);
        this.url = this.getChildText("url", elem);
        this.isProtected = this.getChildBoolean("protected", elem);
        this.followersCount = this.getChildInt("followers_count", elem);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getProfileImageURL() {
        try {
            return new URL(this.profileImageUrl);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public int getFollowersCount() {
        return this.followersCount;
    }

    public DirectMessage sendDirectMessage(String text) throws TwitterException {
        return this.twitter.sendDirectMessage(this.getName(), text);
    }

    public static List<User> constructUsers(Document doc, Twitter twitter) throws TwitterException {
        if (User.isRootNodeNilClasses(doc)) {
            return new ArrayList<User>(0);
        }
        try {
            User.ensureRootNodeNameIs("users", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("user");
            int size = list.getLength();
            ArrayList<User> users = new ArrayList<User>(size);
            for (int i = 0; i < size; ++i) {
                users.add(new User((Element)list.item(i), twitter));
            }
            return users;
        }
        catch (TwitterException te) {
            if (User.isRootNodeNilClasses(doc)) {
                return new ArrayList<User>(0);
            }
            throw te;
        }
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof User && ((User)obj).id == this.id;
    }

    public String toString() {
        return new StringBuffer().append("User{twitter=").append(this.twitter).append(", id=").append(this.id).append(", name='").append(this.name).append('\'').append(", screenName='").append(this.screenName).append('\'').append(", location='").append(this.location).append('\'').append(", description='").append(this.description).append('\'').append(", profileImageUrl='").append(this.profileImageUrl).append('\'').append(", url='").append(this.url).append('\'').append(", isProtected=").append(this.isProtected).append(", followersCount=").append(this.followersCount).append('}').toString();
    }
}

