#! /usr/bin/perl

print "begin;\n";
print "delete from placements;\n";

open PATCHLIST, "../patchlist.txt"
	or die "../patchlist.txt: $!";

my $RANGE = "87.76.";

my $i = 1;
while (<PATCHLIST>) {
	chomp;
	my ($name, $distro, $port) = split / /;

	$name =~ /e(\d+)-(\d+)/;
	my ($e, $s) = ($1, $2);

	my $x = int(320 + $e * 12.27);
	my $y;

	$x += 7  if ($e >= 19);
	$x += 14 if ($e >= 35);
	$x += 9  if ($e >= 51);
	$x += 9  if ($e >= 68 && $s < 4);

	if ($s > 3) {
		$y = 660 - $s * 76 - ($s - 3) * 2;
	} else {
		$y = 690 - $s * 76;
	}

	my $xx = $x + 12;
	my $yy = $y + (($s > 3) ? 68 : 66);

	print "insert into placements (switch, placement) values ($i, box '(($x,$y),($xx,$yy))');\n";
	$i++;
}

print "end;\n";
