#! /usr/bin/perl
use GD;
use LWP::Simple;
use CGI;
use DBI;
use lib '../include';
use nms;

my $cgi = CGI->new;
my $dbh = nms::db_connect();

my @cams = (
	'http://webcam.tg08.gathering.org/webcam.pl',
);

my $cam = $cgi->param('cam');
if (!defined($cam) || !$cams[$cam]) {
	$cam = 0;
}

GD::Image->trueColor(1);
my $imgfile = LWP::Simple::get($cams[$cam])
	or die "LWP: $!";
my $gd = GD::Image->newFromJpegData($imgfile)
	or die "GD: $!";

my @coeffs;
if ($cam == 1)	{
	@coeffs = (
	        2.295433895, -3.779680538, 1041.484066,
		0.2246879859, 6.923972919, -1575.662172,
		-0.0004822922595, 0.01151624710, -1.684908753
	);
} else {
	@coeffs = (
		3.656223906, -6.265111699, 863.9199590,
		-5.954616242, 51.56856164, -9307.725196,
		-0.006634136987, 0.04963057393, -7.875733154
	);
}

# fetch our data
my $q = $dbh->prepare('select * from switches natural left join
		( select switch,sum(bytes_in)/count(*) as
		  bytes_in,sum(bytes_out)/count(*) as bytes_out from get_datarate() group
		  by switch ) t1 where ip<>\'127.0.0.1\' and sysname like \'e%-%sw\'');
$q->execute();

my %sc = ();
while (my $ref = $q->fetchrow_hashref()) {
	if (defined($ref->{'bytes_in'})) {
		my $intensity = 0.0;
		my $traffic = 4.0 * $ref->{'bytes_in'} + $ref->{'bytes_out'};  # average and convert to bits (should be about the same in practice)

		my $max = 20_000_000.0;   # 10mbit
		my $min =    100_000.0;   # 100kbit
		if ($traffic >= $min) {
			$intensity = 2.0 * (log($traffic / $min) / log(10)) / (log($max / $min) / log(10));
			$intensity = 2.0 if ($intensity > 2.0);
		}

		$sc{$ref->{'sysname'}} = get_color($intensity);
	}
}

for my $y (0..479) {
	for my $x (0..639) {
		my $z = 1.0;

		my $nx = $coeffs[0] * $x + $coeffs[1] * $y + $coeffs[2] * $z;
		my $ny = $coeffs[3] * $x + $coeffs[4] * $y + $coeffs[5] * $z;
		my $nz = $coeffs[6] * $x + $coeffs[7] * $y + $coeffs[8] * $z;

		my $kx = $nx / $nz + (($cam == 2) ? 700 : 0);
		my $ky = $ny / $nz + (($cam == 2) ? -15 : 0);

		if ($kx >= 0 && $kx < 640 && $ky >= 0 && $ky < 476) {
			my $col = int($kx / 213) + 1;
			my $row = int($ky / 32) * 2 + 5;

			my $gnf = $sc{"e$row-${col}sw"};
			if (defined($gnf)) {
				my ($ra, $ga, $ba) = $gd->rgb($gd->getPixel($x, $y));
				my ($rb, $gb, $bb) = $gd->rgb($gnf);

				my $f = 0.5;

				my $r = $ra * (1.0 - $f) + $rb * $f;
				my $g = $ga * (1.0 - $f) + $gb * $f;
				my $b = $ba * (1.0 - $f) + $bb * $f;

				$gd->setPixel($x, $y, $gd->colorAllocate($r, $g, $b));
			}
		}
		if ($kx >= 680 && $kx < 1280 && $ky >= 0 && $ky < 476) {
			my $col = int(($kx - 680) / 213) + 4;
			my $row = int($ky / 32) * 2 + 5;

			my $gnf = $sc{"e$row-${col}sw"};
			if (defined($gnf)) {
				my ($ra, $ga, $ba) = $gd->rgb($gd->getPixel($x, $y));
				my ($rb, $gb, $bb) = $gd->rgb($gnf);

				my $f = 0.5;

				my $r = $ra * (1.0 - $f) + $rb * $f;
				my $g = $ga * (1.0 - $f) + $gb * $f;
				my $b = $ba * (1.0 - $f) + $bb * $f;

				$gd->setPixel($x, $y, $gd->colorAllocate($r, $g, $b));
			}
		}
		if ($kx >= 0 && $kx < 640 && $ky >= 510 && $ky < 1050) {
			my $col = int($kx / 213) + 1;
			my $row = int($ky / 32) * 2 + 5;

			my $gnf = $sc{"e$row-${col}sw"};
			if (defined($gnf)) {
				my ($ra, $ga, $ba) = $gd->rgb($gd->getPixel($x, $y));
				my ($rb, $gb, $bb) = $gd->rgb($gnf);

				my $f = 0.5;

				my $r = $ra * (1.0 - $f) + $rb * $f;
				my $g = $ga * (1.0 - $f) + $gb * $f;
				my $b = $ba * (1.0 - $f) + $bb * $f;

				$gd->setPixel($x, $y, $gd->colorAllocate($r, $g, $b));
			}
		}
		if ($kx >= 680 && $kx < 1280 && $ky >= 510 && $ky < 1050) {
			my $col = int(($kx - 680) / 213) + 4;
			my $row = int($ky / 32) * 2 + 5;

			my $gnf = $sc{"e$row-${col}sw"};
			if (defined($gnf)) {
				my ($ra, $ga, $ba) = $gd->rgb($gd->getPixel($x, $y));
				my ($rb, $gb, $bb) = $gd->rgb($gnf);

				my $f = 0.5;

				my $r = $ra * (1.0 - $f) + $rb * $f;
				my $g = $ga * (1.0 - $f) + $gb * $f;
				my $b = $ba * (1.0 - $f) + $bb * $f;

				$gd->setPixel($x, $y, $gd->colorAllocate($r, $g, $b));
			}
		}
	}
}


print CGI::header(-type=>'image/png', -refresh=>'10; ' . CGI::url(-path_info=>1,-query=>1));
print $gd->png;

sub get_color {
        my $intensity = shift;
        my $gamma = 1.0/1.90;
        if ($intensity > 1.0) {
                return $gd->colorAllocate(255.0, 255.0 * ((2.0 - $intensity) ** $gamma), 0);
        } else {
                return $gd->colorAllocate(255.0 * ($intensity ** $gamma), 255, 0);
        }
}

