#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <malloc.h>
#include <vector>
#include <algorithm>
#include "graph.h"
#include "flowpusher.h"
#include "flowutil.h"

int main(int argc, char **argv)
{
	bool total_only = false;
	int width = 500, height = 250;
	
	std::vector<flow_element> flow, total_flow;
	FlowPusher fp(flow);
	int last_port = -1;
	
	mallopt(M_TRIM_THRESHOLD, -1);
	
	if (argc == 2 && strcmp(argv[1], "--total-only") == 0) {
		width = 1000;
		height = 500;
		total_only = true;
	}

	int num_total = 0;
	
	for ( ;; ) {
		int port;
		double x;
		unsigned long long y1, y2;
		
		if (scanf("%d %lf %llu %llu", &port, &x, &y1, &y2) != 4)
			break;

		if (port != last_port) {
			if (last_port != -1) {
				if (!total_only)
					make_graph(last_port, width, height, fp.get_min_x(), fp.get_max_x(), fp.get_min_y(), fp.get_max_y(), flow);
				total_flow = sum_flows(total_flow, flow);
				fprintf(stderr, "%u (%u)\n", last_port, ++num_total);
			}

			// reset
			last_port = port;
			fp.reset(x, y1, y2);
			continue;
		}

		fp.push(x, y1, y2);
	}

	// last graph
	if (!total_only)
		make_graph(last_port, width, height, fp.get_min_x(), fp.get_max_x(), fp.get_min_y(), fp.get_max_y(), flow);
	total_flow = sum_flows(total_flow, flow);
	
	// total graph
	unsigned long long min_y = 0;
	unsigned long long max_y = 10000000;

	for (unsigned i = 0; i < total_flow.size(); ++i) {
		flow_element fe = total_flow[i];
		
		min_y = std::min(min_y, fe.y1);
		max_y = std::max(max_y, fe.y1);
		
		min_y = std::min(min_y, fe.y2);
		max_y = std::max(max_y, fe.y2);
	}
	
	make_graph(65535, width, height, total_flow[0].x, total_flow[total_flow.size() - 1].x, min_y, max_y, total_flow);
}
