#include "graph.h"

int tz_local_offset() { return 3600; } // riktig?


void
mygraph_fill_background(graph *mygraph);

void
mygraph_draw_graph (cairo_t *cr,
		    int x,
		    int y );

graph *
mygraph_new (int width, int height)
{
  graph *mygraph;
  mygraph = (graph *)malloc(sizeof(graph));
  mygraph->width = width;
  mygraph->height = height;


  int stride = width * 4;
  unsigned char *image;
  image = (unsigned char *) malloc (sizeof(unsigned char) * stride * height);

  mygraph->surface = cairo_image_surface_create_for_data (image, CAIRO_FORMAT_ARGB32,
						       width, height, stride);
  mygraph->cr = cairo_create (mygraph->surface);

  cairo_set_source_rgb (mygraph->cr, 1.0, 1.0, 1.0);
  mygraph_fill_background (mygraph);

  cairo_select_font_face (mygraph->cr, "Sans", CAIRO_FONT_SLANT_NORMAL,
			  CAIRO_FONT_WEIGHT_NORMAL);
  cairo_set_font_size (mygraph->cr, 10);

  cairo_set_antialias(mygraph->cr, CAIRO_ANTIALIAS_NONE);
  cairo_set_line_width (mygraph->cr, 1.0);

  return mygraph;
}

graph *
mygraph_make_graph (graph *mygraph, double min_x, double max_x,
		    double min_y, double max_y, int tickgran)
{
  int xoffset = 70;
  cairo_text_extents_t extents;

  mygraph->xoffset = xoffset;
  mygraph->min_x = min_x;
  mygraph->max_x = max_x;
  mygraph->min_y = min_y;
  mygraph->max_y = max_y;

/*   cairo_t *cr; */
/*   cairo_surface_t *surface; */

  double xs = ((double)mygraph->width - (double)(xoffset+2)) /
             (double)(max_x - min_x);

  double ys = ((double)mygraph->height - 33.) / (double)(min_y - max_y);

  mygraph->xs = xs;
  mygraph->ys = ys;

  double starthour = fmod((min_x + (double)tz_local_offset()) / 3600., 24.);
  double diff, center, begin, end;

  char string[20];
 
  int i;
  for (i = 0; i<240; i++)
    { // Hour marks and text
      if ((i % 2) == 0)
	cairo_set_source_rgb (mygraph->cr, 1.0, 1.0, 1.0);
      else
	cairo_set_source_rgb (mygraph->cr, 0.90, 0.90, 1.0);
      
      diff = (double)i - starthour;
      begin = (diff * 3600.) * xs;
      end = ((double)(i+1) - starthour) * 3600.0 * xs;
      center = (begin + end) / 2.;

      if (begin < 0.0)
	continue;
      if (begin > ((double)mygraph->width - ((double)xoffset)))
	continue;

      cairo_rectangle (mygraph->cr, xoffset+begin, 0,
		       end - begin, mygraph->height);
      
      cairo_fill (mygraph->cr);

      if (begin <= 0.0 || end >= mygraph->width - (xoffset))
	continue;

      cairo_set_source_rgb (mygraph->cr, 0.0, 0.0, 0.0);

      sprintf(string, "%d", i % 24);
//           printf("showing string %s @ %fx%f\n", string, xoffset + center - (extents.width/2), (mygraph->height - extents.height - 2));

      cairo_text_extents (mygraph->cr, string, &extents);
      cairo_move_to (mygraph->cr, xoffset + center -
		     (extents.width/2),
		     (mygraph->height - extents.height - 2));

      cairo_show_text (mygraph->cr, string);

    }

  cairo_set_source_rgb (mygraph->cr, 0.4, 0.4, 0.4);
   long long ytick;
  do
    {
      ytick = ((long long)max_y - (long long)min_y) / 11;
      ytick = (long long)(ceil (ytick / tickgran) * tickgran);
      tickgran /= 10;
    } while (((long long)max_y - (long long)min_y) / ytick < 4);

  int y;
  unsigned long long traf;
  for (i = -11; i<12; i++)
    {
      y = (int)((i * ytick - (long long)max_y) * ys + 10);
      if (y < 2 || y > mygraph->height - 18)
	continue;

/*       printf("draw line at %d\n", y); */

      cairo_move_to (mygraph->cr, xoffset, y);
      cairo_line_to (mygraph->cr, mygraph->width-1, y);

      if (i == 0)
	{

	  cairo_set_source_rgb (mygraph->cr, 0.0, 0.0, 1.0);
	  cairo_stroke (mygraph->cr);
	  cairo_set_source_rgb (mygraph->cr, 0.6, 0.6, 0.6);
	}
      else
	cairo_stroke (mygraph->cr);

      // draw text
      traf = 8 * ((unsigned long long)i * ytick);
/*       printf("traffic: %d\n", traf); */

      if (traf >= 500000000)
	sprintf (string, "%.1f Gbit", ((double)traf/1000000000));
      else if (traf >= 500000)
	sprintf (string, "%.1f Mbit", ((double)traf/1000000));
      else
	sprintf (string, "%.1f kbit", ((double)traf/1000));

      cairo_text_extents (mygraph->cr, string, &extents);

/*      if (y - (extents.height/2) < 2 ||
	  y + (extents.height/2) > mygraph->height - (extents.height + 2))
	continue; */

      cairo_move_to (mygraph->cr,
		     xoffset - 4 - extents.width,
		     y + (extents.height/2));

      cairo_show_text (mygraph->cr, string);
    }

  cairo_rectangle (mygraph->cr, xoffset, 0, mygraph->width-xoffset-1, mygraph->height-1);

  cairo_set_source_rgb (mygraph->cr, 0.0, 0.0, 0.0);
  cairo_stroke (mygraph->cr);

  return mygraph;
}

void
mygraph_plot_series (graph *mygraph, int *xvals, unsigned long long *yvals, int n_vals,
		     double r, double g, double b)
{
  int x, i;
  unsigned long long y;
  x = xvals[0];
  y = yvals[0];

  cairo_set_antialias(mygraph->cr, CAIRO_ANTIALIAS_DEFAULT);
  cairo_set_source_rgb (mygraph->cr, r, g, b);

  int xp = (int)((x - mygraph->min_x) * mygraph->xs + mygraph->xoffset + 1);
  int yp = (int)((y - mygraph->max_y) * mygraph->ys + 10);
  
  cairo_move_to (mygraph->cr, xp, yp);

/*   printf("Plotting from:\n");
   printf("(%d, %d) %d (%d, %d)<br/>\n",
 	 x, y, (int)((double)(x - (int)mygraph->min_x) * mygraph->xs + (double)(mygraph->xoffset + 1)) ,
 	 (int)((double)(x - (int)mygraph->min_x) * mygraph->xs + (double)(mygraph->xoffset + 1)),
 	 (int)((double)(y - (int)mygraph->max_y) * mygraph->ys + 10.)); */

  int last_xp = xp, last_yp = yp;
  
  for (i = 1; i < n_vals; i++)
    {
      x = xvals[i];
      y = yvals[i];
      
      int xp = (int)((x - mygraph->min_x) * mygraph->xs + mygraph->xoffset + 1);
      int yp = (int)((y - mygraph->max_y) * mygraph->ys + 10);
      
      if (abs(xp - last_xp) < 2 && yp > last_yp)
	continue;
      
      cairo_line_to (mygraph->cr, xp, yp);
      last_xp = xp;
      last_yp = yp;
    }

  cairo_stroke(mygraph->cr);
}

void
mygraph_to_file (graph *mygraph, char *filename)
{
  cairo_surface_write_to_png (mygraph->surface, filename);
}

void
mygraph_cleanup (graph *self)
{
  cairo_destroy (self->cr);
  cairo_surface_destroy (self->surface);
}

void
mygraph_fill_background (graph *mygraph)
{
  cairo_rectangle (mygraph->cr, 0, 0, mygraph->width, mygraph->height);
  cairo_fill (mygraph->cr);
}

