#!/usr/bin/perl

#use strict;
use warnings;

use Net::Pcap;
use Net::RawIP;
use Time::localtime;

sub out {
	print ctime(time()) . " - " . shift() . "\n";
}

sub healtank { return (shift() eq "heal") ? "tank" : "heal"; }
sub wrongright { return (shift() eq "wrong") ? "right" : "wrong"; }


my $capfile = shift;

my ($s, $err, $filter, $net, $mask);

my $pd;
if(defined $capfile) {
    $pd = Net::Pcap::open_offline($capfile, \$err);
} else {
    $pd = Net::Pcap::open_live('eth0', 8192, 1, 0, \$err);
}

out("error opening capture: " . $err) if $err or not $pd;

{
	my $filter;
	Net::Pcap::compile( $pd, \$filter,
			'dst port 3724 and not ether src 00:30:05:71:f3:81',
			1, $mask )
		&& die("Failed to compile filter");
	Net::Pcap::setfilter($pd, $filter)
		&& die("Error setting filter");
}

out("starting pcap loop");
Net::Pcap::loop($pd, -1, \&handle_packet, "user data");

sub handle_packet {
        my ($user_data, $header, $packet) = @_;
	return unless defined($packet) and length($packet) > 0;

	#out("captured packet");

	my $outpack = Net::RawIP->new({});

	#extract ip-packet from frame
	$outpack->bset(substr($packet, 14));

	my ($data) = $outpack->get( { tcp => [qw(data)] } );

	if(length($data) > 17) {
	    my $a = unpack("c", substr($data, 6, 1));
	    my $b = unpack("c", substr($data, 10, 1));

	    if( $a == 0x01 && ($b == 0x01 || $b == 0x07) ) {
		my $replace = substr($data, 14);
		print "\"" . $replace . " -> ";
		$replace =~ s/(?:lolz|nais|najs)/tech/ig;

		$replace =~ s/(heal|tank)/healtank($1)/eig;
		$replace =~ s/(wrong|right)/wrongright($1)/eig;

		$replace =~ s/instance/glassbur/ig;
		$replace =~ s/dalaran/crewbur/ig;
		$replace =~ s/malygos/7rym!11/ig;
		$replace =~ s/the gathering/vikingskipet!/ig;

		print $replace . "\n";

		$data = substr($data, 0, 14) . $replace;
	    }
	}

	$outpack->set({
	    ip => {
		check => undef,
	    },
	    tcp => {
		check => undef,
		data => $data,
	    }	
	});
	#out("Sending...");

	$outpack->ethnew("eth0", dest => '00:19:a9:b3:04:00', source => '00:30:05:71:f3:81');
	$outpack->ethsend;
}

