#! /usr/bin/perl
use strict;
use warnings;
use DBI;
use Net::Telnet;
package nms;


use base 'Exporter';
our @EXPORT = qw(switch_connect switch_exec switch_disconnect);

BEGIN {
	require "config.pm";
	eval {
		require "config.local.pm";
	};
}

sub db_connect {
	my $dbh = DBI->connect("dbi:Pg:" .
				"dbname=" . $nms::config::db_name .
				";host=" . $nms::config::db_host,
				$nms::config::db_username,
				$nms::config::db_password)
	        or die "Couldn't connect to database";
	return $dbh;	
}

sub switch_connect($) {
	my ($ip) = @_;

	my $conn = new Net::Telnet(	Timeout => $nms::config::telnet_timeout,
#					Dump_Log => '/tmp/dumplog-queue',
					Errmode => 'return',
#					Prompt => '/ES-3023>/');
					Prompt => '/(ES-3024|e\d{1,2}\-\dsw)>/i');
	my $ret = $conn->open(	Host => $ip);
	if (!$ret || $ret != 1) {
		return (undef);
	}
	# XXX: Just send the password as text, I did not figure out how to
	# handle authentication with only password through $conn->login().
	#$conn->login(»·Prompt => '/password[: ]*$/i',
	#		Name => $password,
	#		Password => $password);
	$conn->cmd($nms::config::zyxel_password);
	# Get rid of banner
	$conn->get;
	return ($conn);
}

# Send a command to switch and return the data recvied from the switch
sub switch_exec {
	my ($cmd, $conn, $print) = @_;

	# Send the command and get data from switch
	my @data;
	if (defined($print)) {
		$conn->print($cmd);
		return;
	} else {
		@data = $conn->cmd($cmd);
	}
	my @lines = ();
	foreach my $line (@data) {
		# Remove escape-7 sequence
		$line =~ s/\x1b\x37//g;
		push (@lines, $line);
	}

	return @lines;
}

sub switch_disconnect {
	my ($conn) = @_;
	$conn->close;
}

1;
