#! /usr/bin/perl
open PATCHLIST, "<patchlist.txt"
	or die "patchlist.txt: $!";
my %vlans = ();
my %ports = ();

while (<PATCHLIST>) {
	chomp;
	my ($name, $distro, $port) = split / /;

	$name =~ /e(\d+)-(\d+)/;
	my ($row, $switch) = ($1, $2);

	my $ip;
	if ($switch == 1) {
		$ip = "87.76." . ($row) . ".1";
	} elsif ($switch == 2) {
		$ip = "87.76." . ($row) . ".65";
	} elsif ($switch == 3) {
		$ip = "87.76." . ($row) . ".129";
	} elsif ($switch == 4) {
		$ip = "87.76." . ($row + 1) . ".1";
	} elsif ($switch == 5) {
		$ip = "87.76." . ($row + 1) . ".65";
	} elsif ($switch == 6) {
		$ip = "87.76." . ($row + 1) . ".129";
	}

	my $vlan = "$row$switch";
	my $ipv6 = sprintf "F%02u%u", $row, $switch;

	my $paddedvlan = sprintf("%03d", $vlan);

	$vlans{$distro} .= <<"EOF";
vlan $vlan
  name $name
!
EOF
 
	$ports{$distro} .= <<"EOF";
vlan $vlan
 name $name
default interface vlan $vlan
interface vlan $vlan
  description $name
  ip address $ip 255.255.255.192
  ip directed-broadcast 101
  ip helper-address 87.76.254.2
  no ip proxy-arp
  ip access-group 131 in
  ip igmp version 2
  ip igmp access-group MCGroups
  ip pim sparse-mode
  service-policy input edge-in
  service-policy output edge-out
  ipv6 address tg09 0:0:0:B$paddedvlan\::/64 eui-64
  ipv6 enable
  ipv6 nd other-config-flag
  ipv6 dhcp server tg09
  no shutdown
  exit
!
default interface $port
interface $port
 description $name
 switchport
 switchport trunk encapsulation dot1q
 switchport trunk native vlan $vlan
 switchport trunk allowed vlan 242,$vlan
 switchport mode trunk
 spanning-tree portfast trunk
 spanning-tree bpduguard enable
 
 no shutdown
 exit
!
EOF
}

for my $distro (keys %vlans) {
	open DISTRO, ">$distro-config"
		or die "$distro-config: $!";
#	print DISTRO <<"EOF";
#access-list 101 remark ip directed broadcast
#access-list 101 permit ip any any dscp cs7
#EOF
	print DISTRO $vlans{$distro};
	print DISTRO $ports{$distro};
	print DISTRO "end\n";
	close DISTRO;
}
