#! /usr/bin/perl -w
use strict;

print "# make-missing-zones\n";

my $date = `date --rfc-2822`;
chomp $date;
my $serial = `date +%Y%m%d%M`;
chomp $serial;

my @nets = ();
open NAMES, "switches.txt"
	or die "switches.txt: $!";
while (<NAMES>) {
	chomp;
	/87\.76\.(\d+\.\d+)\s+(\d+)\s+(\S+)/ or next;
	push @nets, {
		net => $1,
		netmask => $2,
		name => $3
	};
}	

for my $net (@nets) {
	my $d = $net->{name};

	-f "/etc/bind/dynamic/$d.tg09.gathering.org" and next;
			
	print "/etc/bind/dynamic/$d.tg09.gathering.org\n";
	open ZONE, ">/etc/bind/dynamic/$d.tg09.gathering.org"
		or die "/etc/bind/dynamic/$d.tg09.gathering.org";

	print ZONE <<"EOF";
; autogenerated and updated from dhcpd -- DO NOT TOUCH!
\$TTL 3600
@	IN	SOA	for.tg09.gathering.org.	abuse.gathering.org. (
			$serial   ; serial
			3600 ; refresh 
			1800 ; retry
			608400 ; expire
			3600 ) ; minimum and default TTL

		IN	NS	for.tg09.gathering.org.
		IN	NS	while.tg09.gathering.org.

EOF
}
