#!/usr/bin/perl
#
# Generates the named zone files for TG Linknet interfazes.
# 
# This magic uses SNMP to retrieve both interface names and ip
# addresses from the netboxes.
#
# WARNING! This does _NOT_ add anything to named.conf (yet),
# and make-named.pl _DOES_ add that in using a temp-hak....
#
# For this code to work, Tech:Net needs to set up the following
# ifName ( interface description ) on the link traverses:
# For direct links (i.e. not port channels) :
# -- LocalGW - RemoteGW --
# For aggregated links:
# --- LocalGW - RemoteGW ---
# Note that we expect the netbox-names to end with GW for the routing boxes,
# in the lines, LocalGW is the name of the netbox that the interface is local
# on, RemoteGW is the netbox the link travereses to.
use strict;
use Net::Telnet::Cisco;
#############################################################################
################ START SCRIPT CONFIGURATION #################################
#############################################################################

# Global configuration stash is not implemented yet, and
# I have not really started, except for a few files round about...
# Theese are definitions that _will_ end up in a global config.
# One year. Perhaps this one, perhaps next.....
my $tgname    = "tg09";
my $pri_a     = "for";
my $pri_ptr   = "87.76.254.2";
my $sec_a     = "while";
my $sec_ptr   = "87.76.255.2";
my $root_arpa = "76.87.in-addr.arpa";

# Tech:Net sets up at least a read-community for SNMP for use
# with ZyxelNG, nms and sosuch. This is the one:
my $snmpcommunity    = "RrCcvJItRMRxY";

my $linknett_zone    = "infra." . $tgname . ".gathering.org";
my $linknett_inaddr  = "0." . $root_arpa;
my $linknett_segment = "87.76.0";

# The following is the list of routing netboxes (core, dist, tele, a.s.o)
my @distrobox_ips = ( 
	"87.76.239.10",
	"87.76.239.11",
	"87.76.239.18",
#	"87.76.239.19",
	"87.76.239.20",
	"87.76.239.21",
	"87.76.239.22",
#	"87.76.239.24",
	"87.76.239.25",
	"87.76.239.26",
	"87.76.239.27",
	"87.76.239.28",
	"87.76.239.58",
	"87.76.239.59"
);

my $fwd_zonefile = "/etc/bind/" . $linknett_zone;
my $rev_zonefile = "/etc/bind/reverse/" . $linknett_inaddr;

my $ios_user = "zyxelng"; 
my $ios_pass = "removed";

my $debug = 0;
print STDERR "Warning, will write diectly to $fwd_zonefile and $rev_zonefile\n\n";

#############################################################################
################ END SCRIPT CONFIGURATION.  #################################
## No settings that need haxxoring allowed below this line, define those   ##
## as variables above, or use already defined vars to build what you need. ##
#############################################################################

my @intindexes;
my %netbox_info;
my $tmp;
my $linknett_regexp = $linknett_segment;
$linknett_regexp =~ s/\./\\./g;

my $serial = `date +%Y%m%d%M`;
chomp $serial;

foreach my $netbox ( @distrobox_ips )
{
	@intindexes = ();

	print STDERR "Connecting to $netbox.\n" if $debug;

   my $ios = Net::Telnet::Cisco->new(Host => $netbox, Errmode => 'return', Prompt => '/\S+[#>]/');
   if (!defined($ios)) {
      print STDERR "Could not connect to $netbox, skipping.\n" if $debug;
		next;
	}

	my $snmpcmd = "snmpwalk -v 1 -Os -c $snmpcommunity " . $netbox;
	my @ltmp = `$snmpcmd ifAlias`;
   foreach ( @ltmp )
	{
		if ( m/ifAlias\.(\d+).*STRING: -+ (.*gw) - (.*gw)/i )
		{
	      print STDERR "Possible link pushed: $1 \t from\t $2 \t to \t $3\n" if $debug;
			push @intindexes, $1;
		}
	}

	$tmp = `$snmpcmd sysName.0`;
	$tmp =~ m/= STRING: (.*)/;
	my $name = $1;
	$name =~ s/\..*//;

	$ios->autopage(0);
	$ios->login($ios_user, $ios_pass);
	$ios->enable;
	$ios->cmd("terminal length 0");


	my @m  = grep( /ip address/,  $ios->cmd("show running-config interface Lo0") );
	my $ipaddr = $m[0]; chomp $ipaddr; 
	# This is absolutely not clean, actually it is filthy! YEY!
	$ipaddr =~ s/ip address //; $ipaddr =~ s/ 255\.255.*//; $ipaddr =~ s/\s//g;
	print STDERR "netbox-entry: " . $name . " -> " . $ipaddr . "\n" if $debug;
	$netbox_info{$name} = $ipaddr;

	foreach my $i ( @intindexes ) 
	{
		# Sanitycheck......
		$tmp = `$snmpcmd ipNetToMediaNetAddress.$i`;
	   if ( $tmp =~ m/\d\.\d+\.\d+\.\d+\.\d+/ )
		{
			$tmp = `$snmpcmd ifName.$i`;
			$tmp =~ m/= STRING: (.*)/;
			my $ifname = $1;
			my $ifhostname = $name . "-" . $ifname;
			$ifhostname =~ s/\//-/g;

			my @m  = grep( /ip address/,  $ios->cmd("show running-config interface " . $ifname) );
 			my $ipaddr = $m[0]; chomp $ipaddr; 

			# This is absolutely not clean, actually it is filthy! YEY!
			$ipaddr =~ s/ip address //; $ipaddr =~ s/ 255\.255.*//; $ipaddr =~ s/\s//g;

			if ( $ipaddr =~ m/$linknett_regexp/ ) {
				$netbox_info{$ifhostname} = $ipaddr;
				print STDERR "Winrar! $ifhostname ( $ifname ) -> $ipaddr is a link.\n" if $debug;
			}
		}
	}
	$ios->close;
	print STDERR "Done with $name..\n\n" if $debug;
}

#----------------------------------
	open FWDZONE, ">$fwd_zonefile";
	print FWDZONE <<"EOF";
\$TTL 3600
@	IN	SOA	$pri_a.$tgname.gathering.org.	abuse.gathering.org. (
			$serial; serial
			3600 ; refresh 
			1800 ; retry
			608400 ; expire
			3600 ) ; minimum and default TTL

		IN	NS	$pri_a.$tgname.gathering.org.
		IN	NS	$sec_a.$tgname.gathering.org.

\$ORIGIN $linknett_zone.

EOF
	foreach my $shorthost ( keys ( %netbox_info ) )
	{
		my $ipaddr = $netbox_info{$shorthost};
		$ipaddr =~ m/^\d+\.\d+\.\d+\.(\d+)/;
		print FWDZONE $shorthost . "\t\tIN\tA\t" . $ipaddr . "\n";
	}
	close FWDZONE;
#----------------------------------

#----------------------------------
	open  REVZONE, ">$rev_zonefile";
	print REVZONE <<"EOF";
\$TTL 3600
@	IN	SOA	$pri_a.$tgname.gathering.org.	abuse.gathering.org. (
			$serial; serial
			3600 ; refresh 
			1800 ; retry
			608400 ; expire
			3600 ) ; minimum and default TTL

		IN	NS	$pri_a.$tgname.gathering.org.
		IN	NS	$sec_a.$tgname.gathering.org.

\$ORIGIN $linknett_inaddr.

EOF

	foreach my $shorthost ( keys ( %netbox_info ) )
	{
		my $ipaddr = $netbox_info{$shorthost};
		# Skip the loopback adresses, they are not linknet adressess...
		next if ( not $ipaddr =~ m/$linknett_regexp/ );

		$ipaddr =~ m/^\d+\.\d+\.\d+\.(\d+)/;
		my $lastoctet = $1;
		print REVZONE $lastoctet . "\t\tIN\tPTR\t" . $shorthost . "." . $linknett_zone . ".\n";
	}
	close REVZONE;
#----------------------------------
