#!/usr/bin/perl
use strict;

my $tgname    = "tg09";
my $pri_a     = "for";
my $pri_ptr   = "87.76.254.2";
my $sec_a     = "while";
my $sec_ptr   = "87.76.255.2";
my $root_arpa = "76.87.in-addr.arpa";
my $top_of_clients = 76;
my @static_switches = (
		  118, 119, 120, 130, 131, 200, 202, 
		  204, 205, 206, 207, 208, 209, 201,
		  212, 213, 215, 216, 220, 222, 223, 
		  224, 225, 250, 148, 149, 150, 151,
		  226
	);
my @static_nets = (
		  0, 239, 240, 241, 242, 243, 251,
		  252, 253, 254, 255
	);

my $ipv6zone = "4.0.8.9.0.c.8.0.1.0.0.2.ip6.arpa";

my $serial = `date +%Y%m%d%M`;
chomp $serial;

open MAINZONE, ">/etc/bind/ttt_" . $tgname . ".gathering.org";
print MAINZONE <<"EOF";
\$TTL 3600
@	IN	SOA	$pri_a.$tgname.gathering.org.	abuse.gathering.org. (
			$serial; serial
			3600 ; refresh 
			1800 ; retry
			608400 ; expire
			3600 ) ; minimum and default TTL

		IN	NS	$pri_a.$tgname.gathering.org.
		IN	NS	$sec_a.$tgname.gathering.org.

$pri_a		IN	A	$pri_ptr
$sec_a		IN	A	$sec_ptr
EOF
close MAINZONE;

open REVZONE, ">/etc/bind/" . $root_arpa;
print REVZONE <<"EOF";
; autogenerated and updated from dhcpd -- DO NOT TOUCH!
\$TTL 3600
@       IN      SOA     $pri_a.$tgname.gathering.org. abuse.gathering.org. (
			$serial; serial
                        3600 ; refresh
                        1800 ; retry
                        608400 ; expire
                        3600 ) ; minimum and default TTL

                IN      NS      $pri_a.$tgname.gathering.org.
                IN      NS      $sec_a.$tgname.gathering.org.
		IN	NS	ns.ripe.net.

EOF

for (my $i=1 ; $i <= $top_of_clients; ++$i ) {
	print REVZONE "$i		IN	NS	$pri_a.$tgname.gathering.org.\n";
	print REVZONE "$i		IN	NS	$sec_a.$tgname.gathering.org.\n";
};

foreach my $i ( @static_switches ) {
	print REVZONE "$i		IN	NS	$pri_a.$tgname.gathering.org.\n";
	print REVZONE "$i		IN	NS	$sec_a.$tgname.gathering.org.\n";
};

foreach my $i ( @static_nets ) {
	print REVZONE "$i		IN	NS	$pri_a.$tgname.gathering.org.\n";
	print REVZONE "$i		IN	NS	$sec_a.$tgname.gathering.org.\n";
};

close REVZONE;

open IPV6ZONE, ">/etc/bind/" . $ipv6zone;
print IPV6ZONE <<"EOF";
; autogenerated and updated from dhcpd -- DO NOT TOUCH!
$TTL 3600
@       IN      SOA     $pri_a.$tgname.gathering.org. abuse.gathering.org. (
			$serial; serial
                        3600 ; refresh
                        1800 ; retry
                        608400 ; expire
                        3600 ) ; minimum and default TTL

                IN      NS      $pri_a.$tgname.gathering.org.
                IN      NS      $sec_a.$tgname.gathering.org.
EOF
close IPV6ZONE;

