#!/usr/bin/perl

use warnings;
use strict;
use lib '../include';
use nms qw(switch_connect switch_exec switch_disconnect);
use Net::Telnet::Cisco;

my @routers = qw(core1.tg09.gathering.org core2.tg09.gathering.org 87.76.239.18);

#
# Fetch list of MAC addresses and IPv6 addresses
#
sub query_router {
	my ($host) = @_;

	my $ios = Net::Telnet::Cisco->new(
			Host => $host,
			Errmode => 'return')
				or warn "Can't connect to $host: $!";
	$ios->autopage(0);
	$ios->login($nms::config::ios_user, $nms::config::ios_pass)
		or warn "Can't login to $host. Wrong username or password?";
	$ios->cmd("terminal length 0");
	my @data = $ios->cmd('show ipv6 neighbors')
		or warn "$host wouldn't let me run command.";

	shift @data; # Remove useless header
	pop @data; # Remove useless empty newline
	return @data;
}

while (1) {
	# Connect to DB
	my $dbh = nms::db_connect();
	$dbh->{AutoCommit} = 0;

	my $i = 0;
	foreach my $router (@routers) {
		foreach my $line (query_router($router)) {
			my ($address, $age, $mac, $status, $vlan) = split('\s+', $line);
			if ($mac =~ /[a-f0-9]{4}\.[a-f0-9]{4}\.[a-f0-9]{4}/ && # Sanity check MAC address
				 $address !~ /^FE.*/) {                             # Filter out non-routable addresses
				my $q = $dbh->prepare('INSERT INTO ipv6 (address, age, mac, vlan, time) VALUES (?, ?, ?, ?, NOW())')
					or warn "Can't prepare query";
				$q->execute($address, $age, $mac, $vlan)
					or warn "Can't execute query";
				$i++;
			}
		}
	}
	print "Added $i IPv6 addresses.\n";
	$i = 0;
	$dbh->commit;
	$dbh->disconnect;
	
	print "Sleeping for two minutes.\n";
	sleep 120; # Sleep for two minutes
}
