; spectrumori-on
; by gasman
	org 25000
	
	ld a,r	; extra randomization!!!!
	ld (Rand16+2),a
	
; fill screen with the 'off' sprite
	ld hl,0x4000
	ld de,0x4001
	ld (hl),l
	ld bc,0x1800
	ldir
	
	ld hl,0x5800
	ld de,0x5801
	ld (hl),0x41
	ld bc,0x02ff
	ldir
	
	xor a
	out (0xfe),a
	
	xor a
draw_initial_cell
	push af
	ld de,gfx_off
	call draw_bmp
	pop af
	inc a
	jr nz,draw_initial_cell
	
	; set up AY
	ld bc,0xfffd
	ld a,7	; mixer reg to all tone
	out (c),a
	ld a,0x38
	ld b,0xbf
	out (c),a
	
	; initial random stuff
	call play_phase
	call play_phase
	; start fade effect
	ld hl,fade
	ld (effect+1),hl
	call play_phase
	call play_phase

	; cascades, with water effect. God, I sound like solo2
	ld hl,music_note
	ld (note_source+1),hl
	ld hl,water
	ld (effect+1),hl
	call play_phase
	call play_phase

	; quicken the pacing
	ld a,0x1f
	ld (pacing+1),a
	; more randomness, with fade
	ld hl,random_note
	ld (note_source+1),hl
	ld hl,fade
	ld (effect+1),hl
	call play_phase
	
	; sd logo, with fade then plain effect
	ld hl,music_note
	ld (note_source+1),hl
	
	call play_phase	; sd09

	ld hl,clear_bar
	ld (effect+1),hl
	call play_phase

	; mute and end
	ld bc,0xfffd
	ld a,0x07
	out (c),a
	ld b,0xbf
	ld a,0x3f
	out (c),a
	call clear_bar
	
die	jr die
	
play_phase	; a phase is 8 bars = 16*8*8 = 0x0400 frames
	ld bc,0x0400
play_loop
	halt
	push bc
	call fade_notes
seq	ld a,0
	inc a
	ld (seq+1),a
	and 0x07
	call z,play_note
	ld a,(seq+1)
pacing:
	and 0x3f	; will become 0x1f later, to quicken the pace
	call z,add_note
	pop bc
	dec bc
	ld a,b
	or c
	jr nz,play_loop
	ret

fade_notes
	ld bc,0xfffd
	ld a,0x08
	out (c),a
	in a,(c)
	or a
	jr z,no_fade_a
	dec a
	ld b,0xbf
	out (c),a
	ld b,0xff
no_fade_a
	ld a,0x09
	out (c),a
	in a,(c)
	or a
	jr z,no_fade_b
	dec a
	ld b,0xbf
	out (c),a
	ld b,0xff
no_fade_b
	ld a,0x0a
	out (c),a
	in a,(c)
	or a
	ret z
	dec a
	ld b,0xbf
	out (c),a
	ret

play_note

effect
	call clear_bar
	; call water
	; call fade
	; call clear_bar

current_col
	ld a,0x0f

	inc a
	and 0x0f
	ld (current_col+1),a

	ld c,0x05	; cyan
	call paint_col
	
	ld a,(current_col+1)	; translate to note table entry
	ld l,a
	add hl,hl
	add hl,hl
	ld h,0x7f
	push hl
	pop ix
	
	; channel A
	ld a,(ix+0)
	dec a
	add a,a	; translate to tone_table entry
	jr c,no_play_a	; but abort if it was zero
	ld l,a
	ld h,0
	ld de,note_periods
	add hl,de
	
	xor a	; low byte
	ld bc,0xfffd
	out (c),a
	ld a,(hl)
	ld b,0xbf
	out (c),a
	inc hl
	ld a,1	; high byte
	ld b,0xff
	out (c),a
	ld a,(hl)
	ld b,0xbf
	out (c),a
	ld a,8	; volume
	ld b,0xff
	out (c),a
	ld a,15
	ld b,0xbf
	out (c),a
	
	ld a,(ix+0)	; y pos
	call light_up_cell

no_play_a
	
	ld a,(ix+1)
	dec a
	add a,a	; translate to tone_table entry
	jr c,no_play_b	; but abort if it was zero
	ld l,a
	ld h,0
	ld de,note_periods
	add hl,de
	
	ld a,2	; low byte
	ld bc,0xfffd
	out (c),a
	ld a,(hl)
	ld b,0xbf
	out (c),a
	inc hl
	ld a,3	; high byte
	ld b,0xff
	out (c),a
	ld a,(hl)
	ld b,0xbf
	out (c),a
	ld a,9	; volume
	ld b,0xff
	out (c),a
	ld a,15
	ld b,0xbf
	out (c),a
	
	ld a,(ix+1)
	call light_up_cell

no_play_b

	ld a,(ix+2)
	dec a
	add a,a	; translate to tone_table entry
	jr c,no_play_c	; but abort if it was zero
	ld l,a
	ld h,0
	ld de,note_periods
	add hl,de
	
	ld a,4	; low byte
	ld b,0xff
	out (c),a
	ld a,(hl)
	ld b,0xbf
	out (c),a
	inc hl
	ld a,5	; high byte
	ld b,0xff
	out (c),a
	ld a,(hl)
	ld b,0xbf
	out (c),a
	ld a,10	; volume
	ld b,0xff
	out (c),a
	ld a,15
	ld b,0xbf
	out (c),a

	ld a,(ix+2)	; y pos
	call light_up_cell

no_play_c
	ret
	
clear_bar
	ld a,(current_col+1)	; translate to note table entry
	ld c,0x41	; bright blue
	call paint_col
; paint the column at index A with attribute byte C
paint_col
	add a,0x88	; translate to low byte of attr
	ld l,a
	ld h,0x58
	ld b,0x10
	ld de,0x20
paint_col_cell
	ld (hl),c
	add hl,de
	djnz paint_col_cell
	ret

random_note
Rand16	ld	de,0		; Seed is usually 0
	ld	a,d
	ld	h,e
	ld	l,253
	or	a
	sbc	hl,de
	sbc	a,0
	sbc	hl,de
	ld	d,0
	sbc	a,d
	ld	e,a
	sbc	hl,de
	jr	nc,Rand
	inc	hl
Rand	ld	(Rand16+1),hl
	ld a,l
	ret
	
music_note
	ld hl,music_data
	ld a,(hl)
	inc hl
	ld (music_note+1),hl
	ret

add_note
note_source
	call random_note

	ld c,a	; save random byte in C

	; find address of note table
	and 0x0f	; get X part
	ld b,a
	rlca
	rlca
	ld l,a
	ld h,0x7f
	
	; check for matching entry
	ld a,c	; get y portion, which is what will be stored in the table
	srl a
	srl a
	srl a
	srl a
	inc a	; note table entries are one higher
	ld d,a	; save transformed Y
	cp (hl)
	ret z
	inc l
	cp (hl)
	ret z
	inc l
	cp (hl)
	ret z
	; no match. find out which entry we should replace
	inc l
	ld a,(hl)	; read cycle byte
	inc a
	cp 3
	jr nz,not_three
	xor a	; reset to 0 if it's reached 3
not_three
	ld (hl),a	; update cycle byte
	ld a,l
	; go back to the appropriate entry
	and 0xfc
	or (hl)
	ld l,a
	ld a,(hl)	; read the byte we're going to replace
	or a	; if it's zero, nothing to unset
	jr z,nothing_to_unset
	; unset cell on screen
	dec a	; translate back to a cell index
	add a,a
	add a,a
	add a,a
	add a,a
	or b	; merge with X part
	push de
	push bc
	push hl
	ld de,gfx_off	; unset cell
	call draw_bmp
	pop hl
	pop bc
	pop de

nothing_to_unset
	; now set new cell
	ld (hl),d
	ld a,c
	ld de,gfx_on
	call draw_bmp
	
	ret
	
; convert matrix byte (in A) to a screen position (in HL),
; then draw the bitmap from DE
draw_bmp
	ld h,0x02
	ld c,a	; save orig byte
	and 0xf0	; get y
	add a,0x40	; convert y
	rl h
	sla a
	rl h
	sla h
	sla h
	sla h
	ld l,a
	ld a,c	; restore orig byte
	and 0x0f	; get x
	add a,0x08	; convert x
	add a,l	; merge
	ld l,a

	rept 7
		ld a,(de)
		ld (hl),a
		inc h
		inc de
	endm
	ret
	
; paint the attribute at A=Y-1, (current_col+1) = X, attr= 0x47 (bright white)
light_up_cell
	add a,3	; now 04-14. A was already preincremented
	ld l,a
	add hl,hl	; now 08-28
	add hl,hl	; now 10-50
	add hl,hl	; now 20-a0
	ld h,0x16	; 0x58 shifted right twice
	add hl,hl
	add hl,hl
	ld a,(current_col+1)
	add a,0x08
	add a,l
	ld l,a
	ld (hl),0x47
	ret

fade
	ld hl,0x5888
	ld c,0x10
fade_row
	ld b,0x10
fade_cell
	ld a,(hl)
	and 0x07
	dec a
	jr nz,notblack
	ld a,0x41	; bright blue
notblack
	ld (hl),a
	inc hl
	djnz fade_cell
	ld de,0x0010
	add hl,de
	dec c
	jr nz,fade_row
	ret

water
	ld ix,0x5888
	ld c,0x10
water_row
	ld b,0x10
water_cell
	ld a,(ix-32)
	add a,(ix-1)
	add a,(ix+1)
	add a,(ix+32)
	and 0x1f
	inc a	; fudge factor
	srl a
	srl a
	jr nz,water_notblack
	ld a,0x41	; bright blue
water_notblack
	ld (ix),a
	inc ix
	djnz water_cell
	ld de,0x0010
	add ix,de
	dec c
	jr nz,water_row
	ret
	

;gfx_active1
;	db %00111000
;	db %01111100
;	db %11111110
;	db %11101110
;	db %11111110
;	db %01111100
;	db %00111000
;
;gfx_active2
;	db %00111000
;	db %01111100
;	db %11101110
;	db %11000110
;	db %11101110
;	db %01111100
;	db %00111000
;
;gfx_active3
;	db %00111000
;	db %01111100
;	db %11000110
;	db %11000110
;	db %11000110
;	db %01111100
;	db %00111000
	
gfx_on
	db %00111000
	db %01101100
	db %11000110
	db %10000010
	db %11000110
	db %01101100
	db %00111000
	db %00000000

gfx_off
	db %00010000
	db %01000100
	db %00000000
	db %10000010
	db %00000000
	db %01000100
	db %00010000
	db %00000000

note_periods
	dw 0x0050	;0
	dw 0x005b	;1
	dw 0x006b	;2
	dw 0x0078	;3
	dw 0x0089	;4
	dw 0x00a0	;5
	dw 0x00b7	;6
	dw 0x00d5	;7
	dw 0x00f0	;8
	dw 0x0112	;9
	dw 0x0140	;a
	dw 0x016e	;b
	dw 0x01ab	;c
	dw 0x01e0	;d
	dw 0x0225	;e
	dw 0x0280	;f

music_data
	db 0x00,0x14,0x28,0x3c	; cascades
	db 0x11,0x25,0x39,0x4d
	db 0x22,0x36,0x4a,0x5e
	db 0x33,0x47,0x5b,0x6f

	db 0xa0,0xa3,0xa6,0xa8,0xaa,0xa1,0xa4,0xae	; bass
	db 0xf2,0xc5,0xb7,0xf9,0xeb,0xdc,0xcd,0xbf	; bass fills
; pseudo-random filler
	db 0x03,0x07,0x08,0x0c
	db 0x03,0x07,0x08,0x0c
	db 0x03,0x07,0x08,0x0c
	db 0x03,0x07,0x08,0x0c
	db 0xf0,0xf2,0xf3,0x13,0xf4,0xe4,0xf5,0xf7,0x17,0xf8,0xe8,0xfa,0xfc,0x1c
	db 0x03,0x07,0x08,0x0c
; sd09 logo
	db 0x61,0x62,0x6a,0x6e
	db 0x70,0x76,0x79,0x7b,0x7d,0x7f
	db 0x81,0x85,0x86,0x89,0x8b,0x8d,0x8e,0x8f
	db 0x92,0x94,0x99,0x9b,0x9f
	db 0xa0,0xa1,0xa5,0xa6,0xaa,0xad,0xae