#include "xlib.h"

/* do we want to print information on start?
 * we use this for debugging
 */
/* #define DEBUG */

/* function called when our window is resized */
void resizeGLScene(unsigned int width, unsigned int height)
{
  if(height == 0)    /* Devide by zero WTFFFFFFFFFFFFFFFFFFFFFFFF? */
    height = 1;
  glViewport(0, 0, width, height);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(40.0f, (GLfloat)width / (GLfloat)height, 0.1f, 100.0f);
  glMatrixMode(GL_MODELVIEW);
}

/* this function creates our window */
Bool createGLWindow(char* title, int width, int height, Bool fullscreenflag)
{
  XVisualInfo *vi;
  Colormap cmap;
  int dpyWidth, dpyHeight;
  int i;
  int glxMajorVersion, glxMinorVersion;
  int vidModeMajorVersion, vidModeMinorVersion;
  XF86VidModeModeInfo **modes;
  int modeNum;
  int bestMode;
  Atom wmDelete;
  Window winDummy;
  unsigned int borderDummy;
  GLWin.fs = fullscreenflag;
  /* set best mode to current */
  bestMode = 0;
  /* get a connection */
  GLWin.dpy = XOpenDisplay(0);
  GLWin.screen = DefaultScreen(GLWin.dpy);
  XF86VidModeQueryVersion(GLWin.dpy, &vidModeMajorVersion,
			  &vidModeMinorVersion);
#ifdef DEBUG
  printf("XF86VidModeExtension-Version %d.%d\n", vidModeMajorVersion,
	 vidModeMinorVersion);
#endif
  XF86VidModeGetAllModeLines(GLWin.dpy, GLWin.screen, &modeNum, &modes);
  /* save desktop-resolution before switching modes, we want to return, don't we? */
  GLWin.deskMode = *modes[0];
  /* check for mode with requested resolution */
  for (i = 0; i < modeNum; i++)
    {
      if ((modes[i]->hdisplay == width) && (modes[i]->vdisplay == height))
        {
	  bestMode = i;
        }
    }
  vi = glXChooseVisual(GLWin.dpy, GLWin.screen, attrListDbl);
  if (vi == NULL)
    {
      vi = glXChooseVisual(GLWin.dpy, GLWin.screen, attrListSgl);
      GLWin.doubleBuffered = False;
#ifdef DEBUG
      printf("Only Singlebuffered Visual!\n");
#endif
    }
  else
    {
      GLWin.doubleBuffered = True;
#ifdef DEBUG      
      printf("Got Doublebuffered Visual!\n");
#endif
    }
  glXQueryVersion(GLWin.dpy, &glxMajorVersion, &glxMinorVersion);
#ifdef DEGUB
  printf("glX-Version %d.%d\n", glxMajorVersion, glxMinorVersion);
#endif
  GLWin.ctx = glXCreateContext(GLWin.dpy, vi, 0, GL_TRUE);
  cmap = XCreateColormap(GLWin.dpy, RootWindow(GLWin.dpy, vi->screen),
			 vi->visual, AllocNone);
  GLWin.attr.colormap = cmap;

  // make a blank cursor
  static char data[1] = {0};
  Cursor cursor;
  Pixmap blank;
  XColor dummy;

  blank = XCreateBitmapFromData(GLWin.dpy, RootWindow(GLWin.dpy, vi->screen), data, 1, 1);
  if (blank == None) {
    fprintf (stderr, "Out of memory, couldn't create PixmapCursor\n");
  }
  cursor = XCreatePixmapCursor(GLWin.dpy, blank, blank, &dummy, &dummy, 0, 0);
  XFreePixmap(GLWin.dpy, blank);
  GLWin.attr.cursor = cursor;


  GLWin.attr.border_pixel = 0;
  if (GLWin.fs)
    {
      XF86VidModeSwitchToMode(GLWin.dpy, GLWin.screen, modes[bestMode]);
      XF86VidModeSetViewPort(GLWin.dpy, GLWin.screen, 0, 0);
      dpyWidth = modes[bestMode]->hdisplay;
      dpyHeight = modes[bestMode]->vdisplay;
#ifdef DEBUG
      printf("Resolution %dx%d\n", dpyWidth, dpyHeight);
#endif
      XFree(modes);
      /* create a fullscreen window */
      GLWin.attr.override_redirect = True;
      GLWin.attr.event_mask = ExposureMask | KeyPressMask | ButtonPressMask |
	StructureNotifyMask;
      GLWin.win = XCreateWindow(GLWin.dpy, RootWindow(GLWin.dpy, vi->screen),
				0, 0, dpyWidth, dpyHeight, 0, vi->depth, InputOutput, vi->visual,
				CWBorderPixel | CWColormap | CWCursor | CWEventMask | CWOverrideRedirect,
				&GLWin.attr);
      XWarpPointer(GLWin.dpy, None, GLWin.win, 0, 0, 0, 0, 0, 0);
      XMapRaised(GLWin.dpy, GLWin.win);
      XGrabKeyboard(GLWin.dpy, GLWin.win, True, GrabModeAsync,
		    GrabModeAsync, CurrentTime);
      XGrabPointer(GLWin.dpy, GLWin.win, True, ButtonPressMask,
		   GrabModeAsync, GrabModeAsync, GLWin.win, None, CurrentTime);
    }
  else
    {
      /* create a window in window mode*/
      GLWin.attr.event_mask = ExposureMask | KeyPressMask | ButtonPressMask |
	StructureNotifyMask;
      GLWin.win = XCreateWindow(GLWin.dpy, RootWindow(GLWin.dpy, vi->screen),
				0, 0, width, height, 0, vi->depth, InputOutput, vi->visual,
				CWBorderPixel | CWColormap | CWEventMask, &GLWin.attr);
      /* only set window title and handle wm_delete_events if in windowed mode */
      wmDelete = XInternAtom(GLWin.dpy, "WM_DELETE_WINDOW", True);
      XSetWMProtocols(GLWin.dpy, GLWin.win, &wmDelete, 1);
      XSetStandardProperties(GLWin.dpy, GLWin.win, title,
			     title, None, NULL, 0, NULL);
      XMapRaised(GLWin.dpy, GLWin.win);
    }       
  /* connect the glx-context to the window */
  glXMakeCurrent(GLWin.dpy, GLWin.win, GLWin.ctx);
  XGetGeometry(GLWin.dpy, GLWin.win, &winDummy, &GLWin.x, &GLWin.y,
	       &GLWin.width, &GLWin.height, &borderDummy, &GLWin.depth);
#ifdef DEBUG
  printf("Depth %d\n", GLWin.depth);
#endif
  if (glXIsDirect(GLWin.dpy, GLWin.ctx)) 
#ifdef DEBUG
    printf("Congrats, you have Direct Rendering!\n");
  else
#endif
#ifdef DEBUG
    printf("Sorry, no Direct Rendering possible!\n");
#endif
  initGL();
  return True;    
}

GLvoid killGLWindow(GLvoid)
{
  if (GLWin.ctx)
    {
      if (!glXMakeCurrent(GLWin.dpy, None, NULL))
        {
	  printf("Could not release drawing context.\n");
        }
      glXDestroyContext(GLWin.dpy, GLWin.ctx);
      GLWin.ctx = NULL;
    }
  if (GLWin.fs)
    {
      XF86VidModeSwitchToMode(GLWin.dpy, GLWin.screen, &GLWin.deskMode);
      XF86VidModeSetViewPort(GLWin.dpy, GLWin.screen, 0, 0);
    }
  XCloseDisplay(GLWin.dpy);
}

void glMainLoop(char *name, int xres, int yres)
{
  Bool done;
  done = False;
  GLWin.fs = True; /* FIXME */
  createGLWindow(name, xres, yres, GLWin.fs);
  while (!done)
    {
      while (XPending(GLWin.dpy) > 0)
        {
	  XNextEvent(GLWin.dpy, &event);
	  switch (event.type)
            {
	    case Expose:
	      if (event.xexpose.count != 0)
		break;
	      drawGLScene();
	      break;
            case ConfigureNotify:
	      if ((event.xconfigure.width != GLWin.width) || 
		  (event.xconfigure.height != GLWin.height))
                {
		  GLWin.width = event.xconfigure.width;
		  GLWin.height = event.xconfigure.height;
		  printf("Resize event\n");
		  resizeGLScene(event.xconfigure.width,
				event.xconfigure.height);
                }
	      break;
            case KeyPress:
	      /* exit on ESC */
	      if(XLookupKeysym(&event.xkey, 0) == XK_Escape) {
		done = True;
	      }
	      /* go into window mode with F12 */
	      if(XLookupKeysym(&event.xkey,0) == XK_F12) {
		/* kill the fullscreen window */
		killGLWindow();
		/* we don't want a fullscreen window anymore */
		GLWin.fs = !GLWin.fs;
		/* reopen opengl window */
		createGLWindow(name, xres, yres, GLWin.fs);
	      }
	      break;
            case ClientMessage:    
	      if (*XGetAtomName(GLWin.dpy, event.xclient.message_type) == 
		  *"WM_PROTOCOLS") {
		printf("Exiting sanely...\n");
		done = True;
	      }
	      break;
            default:
	      break;
            }
        }
      /* Draw TAH realtime pr0n for y00 t00 k00l f0r sk00l d00d3z */
      drawGLScene();
    }
}
