#include "main.h"

GLuint EmptyTexture()
{
  GLuint txtnumber;
  unsigned int* data;
  data = (GLuint *)calloc( 1, ((128 * 128)* 4 * sizeof(GLuint)) );
  glGenTextures(1, &txtnumber);
  glBindTexture(GL_TEXTURE_2D, txtnumber);
  glTexImage2D(GL_TEXTURE_2D, 0, 4, 256, 256, 0,
	       GL_RGBA, GL_UNSIGNED_BYTE, data);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  free( data );
  return txtnumber;
}

void ViewOrtho()
{
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();							
  glLoadIdentity();
  glOrtho( 0, 640 , 480 , 0, -1, 1 );
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
}

void ViewPerspective()
{
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
}

void RenderToTexture(float rut)
{
  glViewport(0, 0, 256, 256);
  glTranslatef(0.0, 0.0, -3.0);
  glEnable(GL_TEXTURE_2D);
  glRotatef(rut, 0.5, 0.2, 0.6);
  glBindTexture(GL_TEXTURE_2D, textures[0].texid);

  harmo (30, 30, 2, 2, 1, 1, 1,
	 1, 1, 1, 1);

  glBindTexture(GL_TEXTURE_2D, blurr_tex);
  glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, 256, 256, 0);
  glViewport(0, 0, 640, 480);
  glClear(GL_COLOR_BUFFER_BIT);
}


void DrawBlur(int times, float inc)
{
  float spost = 0.0f;
  float alphainc = 0.2f / times;
  float alpha = 0.2f;
  int num;
  float xres=640, yres=480;
  glDisable(GL_TEXTURE_GEN_S);
  glDisable(GL_TEXTURE_GEN_T);
  glEnable(GL_TEXTURE_2D);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_SRC_ALPHA,GL_ONE);
  glEnable(GL_BLEND);
  glBindTexture(GL_TEXTURE_2D, blurr_tex);
  ViewOrtho();
  alphainc = alpha / times;
  glBegin(GL_QUADS);
  for (num = 0;num < times;num++)
    {
      glColor4f(0.6f, 0.5f, 0.5f, alpha);
      glTexCoord2f(0+spost,1-spost);
      glVertex2f(0,0);
      glTexCoord2f(0+spost,0+spost);
      glVertex2f(0,yres);
      glTexCoord2f(1-spost,0+spost);
      glVertex2f(xres,yres);
      glTexCoord2f(1-spost,1-spost);
      glVertex2f(xres,0);
      spost += inc;
      alpha = alpha - alphainc;
    }
  glEnd();
  ViewPerspective();
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
  glBindTexture(GL_TEXTURE_2D,0);
}
