#include "main.h"
#include "maths.h"

void normalize_3(float v1, float v2, float v3)
{
  /* calculate length of vector */
  float length;

  __asm__ (
	   "movss %1, %%xmm0;"
	   "mulss %%xmm0, %%xmm0;"
	   "movss %2, %%xmm1;"
	   "mulss %%xmm1, %%xmm1;"

	   "addss %%xmm0, %%xmm1;"

	   "movss %3, %%xmm2;"
	   "mulss %%xmm2, %%xmm2;"
	   "addss %%xmm1, %%xmm2;"
	   "sqrtss %%xmm2, %%xmm2;"
	   "movss %%xmm2, %0;"
	   : "=m" (length)
	   : "m" (v1), "m" (v2), "m" (v3)
	   );

  if(length == 0) {
    printf("Vector has length zero, but that's... impossible!\n");
    return;
  }
  __asm__ (
	   "movss %0, %%xmm0;"
	   "movss %1, %%xmm1;"
	   "movss %2, %%xmm2;"

	   "divss %3, %%xmm0;"
	   "movss %%xmm0, %0;"

	   "divss %3, %%xmm1;"
	   "movss %%xmm1, %1;"

	   "divss %3, %%xmm2;"
	   "movss %%xmm2, %2;"
	   : "=m" (v1), "=m" (v2), "=m" (v3)
	   : "m" (length)
	   );
  glNormal3f(v1, v2, v3);
}

vector3d evalharmo(double theta, double phi, double sinea, double t1, double t2,
		   double hei, double wid1, double wid2,
		   float d1, float d2, float d3, float d4)
{
  /* please optimize sometime */
  double r = 0;
  vector3d p;
  r += pow ( pow(sin(2*phi+sinea), 2), d1);
  r += pow ( pow(cos(2*phi+sinea), t1), d2);
  r += pow ( pow(sin(2*theta+sinea), 2), d3);
  r += pow ( pow(cos(2*theta+sinea), t2), d4);

  p.x = r * sin(phi) * cos(theta)*wid1;
  p.y = r * cos(phi) * hei;
  p.z = r * sin(phi) * sin(theta)*wid2;
  return(p);
}

/* Draws the Spherical Harmonics 
 * resolution, movement, x "waves", y "waves", height, width x, width y 
 * bla bla bla
 */
void harmo(double resolution, double move, double o1, double o2,
	   double hei, double wid1, double wid2,
	   float d1, float d2, float d3, float d4)
{
  vector3d q[4];
  int i, j;
  double du = TWOPI / (double)resolution;
  double dv = PI / (double)resolution;
  glBegin(GL_QUADS);
  for (i=0;i<resolution;i++) {
    double u = i * du;
    for (j=0;j<resolution;j++) {
      double v = j * dv;
      q[0] = evalharmo(u, v, move, o1, o2, hei, wid1, wid2,
		       d1, d2, d3, d4);
      normalize_3(q[0].x, q[0].y, q[0].z);
      glVertex3f(q[0].x, q[0].y, q[0].z);

      q[1] = evalharmo(u+du, v, move, o1, o2, hei, wid1, wid2,
		       d1, d2, d3, d4);
      normalize_3(q[1].x, q[1].y, q[1].z);
      glVertex3f(q[1].x, q[1].y, q[1].z);

      q[2] = evalharmo(u+du, v+dv, move, o1, o2, hei, wid1, wid2,
		       d1, d2, d3, d4);
      normalize_3(q[2].x, q[2].y, q[2].z);
      glVertex3f(q[2].x, q[2].y, q[2].z);

      q[3] = evalharmo(u, v+dv, move, o1, o2, hei, wid1, wid2,
		       d1, d2, d3, d4);
      normalize_3(q[3].x, q[3].y, q[3].z);
      glVertex3f(q[3].x, q[3].y, q[3].z);
    }
  }
  glEnd();
}
