#include "main.h"
#include <sys/time.h>
#include <time.h>
#include "xlib.h"
/* #include "light.h" */

#define sync(a, c)  if(t_time>a&&t_time<a+0.1)speed=c

GLfloat light1_position[] = {-4.0, 0.0, 2.0, 0.0 };
GLfloat light2_position[] = {   4,   2,   1,   0 };

#define BINDTEX(num) glBindTexture(GL_TEXTURE_2D, textures[num].texid)

float dude;
int random_value = 0;
int new_rv = 0;
int bleh = 0;
float speed;

void sellips(double, double, int);
void oval(double a, double b, int type);

float
getTime()
{
  struct timeval t1;
  gettimeofday(&t1, NULL);
  return ((t1.tv_sec * 1000) + (t1.tv_usec / 1000) - starttime);
}

void ViewOrtho()
{
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();							
  glLoadIdentity();
  glOrtho( 0, 640 , 480 , 0, -1, 1 );
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
}

void ViewPerspective()
{
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
}

int drawGLScene(GLvoid)
{
  float a = 0;
  int i, j;
  int o, p;
  t_time = getTime ()/1000;

  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  if((t_time - dude) > 0.6) {
    dude = t_time;
    new_rv = 1 + (rand() % 4);
  }
  glClearColor(0.0, 0, 0, 0);
  glDisable (GL_TEXTURE_2D);
  glDisable (GL_DEPTH_TEST);
  glEnable (GL_BLEND);
  for (o = -10; o < 30; o++)
    {
      for (p = -10; p < 30; p++)
	{
	  glLoadIdentity ();
	  glRotatef (sin(t_time)*20, 1, 0.5, 0.2);
	  glRotatef (t_time*5, 0, 0, 1);
	  /* do YOU have a 2ghz cpu? :D */
	  glTranslatef (-9.5+o+sin(t_time + new_rv)*5,
			-9.5+p+cos(t_time + new_rv)*5,
			-8-sin(o+t_time*5)*cos(p+t_time*5)*0.2);
	  glColor3f (0.1+(sin(o+t_time*2)*cos(p+t_time*3))/1,
		     0.1+(sin(o+t_time*2)*cos(p+t_time*3))/3,
		     0.1+(sin(o+t_time*2)*cos(p+t_time*3))/3);
	  glSmallCube ();
	}
    }

  glLoadIdentity();
  glTranslatef (0.5, 0.0, -3.0);
  BINDTEX (8);
  glEnable (GL_TEXTURE_2D);
  glColor3f (1, 1, 1);
  glBegin(GL_QUADS);
  glTexCoord2f (0, 1); glVertex2f (-1, -1);
  glTexCoord2f (0, 0); glVertex2f (-1,  1);
  glTexCoord2f (1, 0); glVertex2f ( 1,  1);
  glTexCoord2f (1, 1); glVertex2f ( 1, -1);
  glEnd();

  glLoadIdentity();
  glTranslatef (-0.9, -4.0+t_time/4, -3.0);
  BINDTEX (11);
  glEnable (GL_TEXTURE_2D);
  glColor3f (1, 1, 1);
  glBegin(GL_QUADS);
  glTexCoord2f (0, 1); glVertex2f (-0.6, -2.4);
  glTexCoord2f (0, 0); glVertex2f (-0.6,  2.4);
  glTexCoord2f (1, 0); glVertex2f ( 0.6,  2.4);
  glTexCoord2f (1, 1); glVertex2f ( 0.6, -2.4);
  glEnd();

  if(t_time >= 33)
    exit(0);

  glXSwapBuffers(GLWin.dpy, GLWin.win);
  return 0;
}

void DrawBlur(int times, float inc)
{
  float spost = 0.0f;
  float alphainc = 0.9f / times;
  float alpha = 0.2f;
  int num;
  float xres=640, yres=480;
  glDisable(GL_TEXTURE_GEN_S);
  glDisable(GL_TEXTURE_GEN_T);
  glEnable(GL_TEXTURE_2D);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_SRC_ALPHA,GL_ONE);
  glEnable(GL_BLEND);
  glBindTexture(GL_TEXTURE_2D, blurr_tex);
  ViewOrtho();
  alphainc = alpha / times;
  glBegin(GL_QUADS);

  for (num = 0;num < times;num++)
    {
      glColor4f(1.0f, 1.0f, 1.0f, alpha);
      glTexCoord2f(0+spost,1-spost);
      glVertex2f(0,0);
      glTexCoord2f(0+spost,0+spost);
      glVertex2f(0,yres);
      glTexCoord2f(1-spost,0+spost);
      glVertex2f(xres,yres);
      glTexCoord2f(1-spost,1-spost);
      glVertex2f(xres,0);
      spost += inc;
      alpha = alpha - alphainc;
    }
  glEnd();
  ViewPerspective();
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_BLEND);
  glBindTexture(GL_TEXTURE_2D,0);
}

GLuint EmptyTexture()
{
  GLuint txtnumber;
  unsigned int* data;
  data = (GLuint *)calloc( 1, ((128 * 128)* 4 * sizeof(GLuint)) );
  glGenTextures(1, &txtnumber);
  glBindTexture(GL_TEXTURE_2D, txtnumber);
  glTexImage2D(GL_TEXTURE_2D, 0, 4, 256, 256, 0,
	       GL_RGBA, GL_UNSIGNED_BYTE, data);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
  free( data );
  return txtnumber;
}

int initGL(GLvoid)
{

  load_textures();
  blurr_tex = EmptyTexture();

  GLfloat ambient[] = { 1, 0.0, 0.0, 0.0 };
  glLightfv(GL_LIGHT0, GL_POSITION, light1_position);
  glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);

  glLightfv(GL_LIGHT1, GL_POSITION, light2_position);
  glLightfv(GL_LIGHT1, GL_AMBIENT, ambient);

  init();
  resizeGLScene(GLWin.width, GLWin.height);
  return 0;
}

int main(int argc, char **argv)
{
  if(pid = fork()) {
    ogg_play();
  } else {

    struct timeval temp;
    gettimeofday(&temp, NULL);
    starttime = (temp.tv_sec * 1000) + (temp.tv_usec / 1000);

    glMainLoop("happy birthday XNi", 1280, 720);
    killGLWindow();
/*     kill(pid, SIGINT); */
  }
  /*    ogg_quit(); */
  kill(pid, SIGINT);
  return 0;
}
