#include <linux/soundcard.h>
#include <fcntl.h>
#include <regex.h>
#include "vorbis/codec.h"
#include "vorbis/vorbisfile.h"
#include "main.h"
#include "init.h"

/* #include "light.h" */

int t_ioctl(int arg1, int val)
{
  return ioctl(fd_dsp, arg1, &val);
}

void load_textures()
{
  load_tex("data/tufs.png", 0);
  load_tex("data/perspective0.png", 1);
/*   load_tex("noise.png", 2); */
  load_tex("data/back2d.png", 3);
/*   load_tex("overlay.png", 4); */
/*   load_tex("perspective1.png", 5); */
  load_tex("data/nisse3.png", 6);
  load_tex("data/getu.png", 7);
  load_tex("data/plasmagreet.png", 8);
/*   load_tex("plasmawall.png", 9); */
  load_tex("data/gibson.png", 10);
  load_tex("data/listgreet.png", 11);
}

int ogg_quit()
{
  if(ov_clear(&vf) == 0) {
    printf("Done playing OGG sound.\n");
    return 0;
  }
}

void init(void)
{
  glFogi(GL_FOG_MODE, fogmode[fogfilter]);
  glFogfv(GL_FOG_COLOR, fogcolor);
  glFogf(GL_FOG_DENSITY, 0.25f);
  glHint(GL_FOG_HINT, GL_DONT_CARE);
  glFogf(GL_FOG_START, 11.0f);
  glFogf(GL_FOG_END, 10.0f);
  glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
  glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);

  glBlendFunc(GL_ONE, GL_ONE);

/*    glLightfv(GL_LIGHT0, GL_POSITION, light1_position); */
  
  glMaterialfv(GL_FRONT, GL_AMBIENT, mat_ambient);
  glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
  glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
  glMaterialf(GL_FRONT, GL_SHININESS, 10);
  glMaterialfv(GL_FRONT, GL_EMISSION, mat_emission);
}

void ogg_play()
{
  if((file = fopen("data/xnibursdag.ogg", "rb")) == NULL) {
    printf("Could not open file\n");
    exit(1);
  }
  if(ov_open(file, &vf, NULL, 0) < 0) {
    printf("Not a valid ogg file\n");
    exit(1);
  }
  fd_dsp = open("/dev/dsp", O_WRONLY, 0);
  info = ov_info(&vf, -1);
  t_ioctl(SOUND_PCM_WRITE_RATE, info->rate);
  t_ioctl(SOUND_PCM_WRITE_CHANNELS, info->channels);
  t_ioctl(SNDCTL_DSP_SETFMT, AFMT_S16_LE);
  while(ret != 0) {
    ret = ov_read(&vf, buf, sizeof(buf), 0, 2, 1, &current_sec);
    if((write(fd_dsp, buf, ret)) == -1) {
      printf ("Could not write do /dev/dsp! Already in use?\n");
      printf ("Try: `fuser -k /dev/dsp` if unsure\n");
      kill (pid, SIGINT);
      exit(0);
    }
    if(ret==0) {
      ogg_quit();
    }
  }
}

