uniform sampler2D Texture;
uniform sampler2D HeightMap;

varying vec3 vNormal;
uniform float Erosion;
uniform float TextureScale;

varying float Depth;
uniform float StartDarkness;
uniform float SizeFalloff;

void main(void)
{
   float Intensity = normalize( vNormal ).z * 0.3 + 0.7;
   
   float theHeight = texture2D( HeightMap, gl_TexCoord[0].st ).x;
   
   if ( theHeight < Erosion )
      discard;
   else   
   {   
      float theDark = 1 - clamp( Depth - StartDarkness , 0.0, SizeFalloff ) /SizeFalloff;
      gl_FragColor = Intensity * theDark * texture2D( Texture, 
        vec2( gl_TexCoord[0].s * TextureScale, gl_TexCoord[0].t * TextureScale) ) ;
   }
}