
void main()
{
	vec4 cameraPosition = gl_ModelViewMatrixInverse[3];
	float phi = atan(cameraPosition.x, cameraPosition.z);
	float theta = atan(length(cameraPosition.xz), cameraPosition.y);
	mat3 Rphi = mat3(vec3(cos(phi), 0.0, -sin(phi)),
	                 vec3(0.0, 1.0, 0.0),
	                 vec3(sin(phi), 0.0, cos(phi)));
	mat3 Rtheta = mat3(vec3(1.0, 0.0, 0.0),
	                   vec3(0.0, cos(theta), sin(theta)),
	                   vec3(0.0, -sin(theta), cos(theta)));
	                  
	vec3 Vertex = gl_Vertex.xyz;
	vec3 RotVertex = Rphi * Rtheta * Vertex;
	gl_Position = gl_ModelViewProjectionMatrix * vec4(RotVertex,gl_Vertex.w);
	gl_TexCoord[0] = gl_MultiTexCoord0;
}
