/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.Matrix;
import vitamin.math.Vector3;

public class Vector4 {
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4() {
        this.w = 0.0f;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector4(float xx, float yy, float zz, float ww) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
        this.w = ww;
    }

    public Vector4(Vector3 v, float ww) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = ww;
    }

    public Vector4(Vector4 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
    }

    public void set(float xx, float yy, float zz, float ww) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
        this.w = ww;
    }

    public void set(Vector3 v, float ww) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = ww;
    }

    public void set(Vector4 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
    }

    public void reset() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
    }

    public Vector4 copy() {
        return new Vector4(this.x, this.y, this.z, this.w);
    }

    public Vector4 clone() {
        return new Vector4(this.x, this.y, this.z, this.w);
    }

    public Vector3 copy3() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Vector3 clone3() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Vector3 xyz() {
        return new Vector3(this.x, this.y, this.z);
    }

    public void add(Vector4 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        this.w += v.w;
    }

    public void sub(Vector4 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        this.w *= v.w;
    }

    public void mul(Vector4 v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        this.w *= v.w;
    }

    public void div(Vector4 v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        this.w /= v.w;
    }

    public void mul(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w *= s;
    }

    public void div(float s) {
        float inv = 1.0f / s;
        this.x *= inv;
        this.y *= inv;
        this.z *= inv;
        this.w *= inv;
    }

    public float dot(Vector4 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    public Vector3 cross(Vector4 v) {
        float crossX = this.y * v.z - v.y * this.z;
        float crossY = this.z * v.x - v.z * this.x;
        float crossZ = this.x * v.y - v.x * this.y;
        return new Vector3(crossX, crossY, crossZ);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void normalize() {
        float m = this.length();
        if (m > 0.0f) {
            this.div(m);
        }
    }

    public Vector4 lerp(Vector4 V1, float s) {
        return new Vector4(this.x + s * (V1.x - this.x), this.y + s * (V1.y - this.y), this.z + s * (V1.z - this.z), this.w + s * (V1.w - this.w));
    }

    public boolean SetBaryCentric(Vector4 V1, Vector4 V2, Vector4 V3, float f, float g) {
        this.x = V1.x + f * (V2.x - V1.x) + g * (V3.x - V1.x);
        this.y = V1.y + f * (V2.y - V1.y) + g * (V3.y - V1.y);
        this.z = V1.z + f * (V2.z - V1.z) + g * (V3.z - V1.z);
        return true;
    }

    public Vector4 transform(Matrix m) {
        float xx = this.x * m._M[0] + this.y * m._M[4] + this.z * m._M[8] + m._M[12];
        float yy = this.x * m._M[1] + this.y * m._M[5] + this.z * m._M[9] + m._M[13];
        float zz = this.x * m._M[2] + this.y * m._M[6] + this.z * m._M[10] + m._M[14];
        float ww = 0.0f;
        return new Vector4(xx, yy, zz, ww);
    }

    public static Vector4 add(Vector4 a, Vector4 b) {
        return new Vector4(a.x + b.x, a.y + b.y, a.z + b.z, a.w + b.w);
    }

    public static Vector4 sub(Vector4 a, Vector4 b) {
        return new Vector4(a.x - b.x, a.y - b.y, a.z - b.z, a.w - b.w);
    }

    public static Vector4 mul(Vector4 a, Vector4 b) {
        return new Vector4(a.x * b.x, a.y * b.y, a.z * b.z, a.w * b.w);
    }

    public static Vector4 mul(Vector4 a, float f) {
        return new Vector4(a.x * f, a.y * f, a.z * f, a.w * f);
    }

    public static Vector3 cross(Vector3 a, Vector3 b) {
        float crossX = a.y * b.z - b.y * a.z;
        float crossY = a.z * b.x - b.z * a.x;
        float crossZ = a.x * b.y - b.x * a.y;
        return new Vector3(crossX, crossY, crossZ);
    }

    public static float distance(Vector4 v1, Vector4 v2) {
        float dx = v1.x - v2.x;
        float dy = v1.y - v2.y;
        float dz = v1.z - v2.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static float angleBetween(Vector4 v1, Vector4 v2) {
        float dot = v1.dot(v2);
        float theta = (float)Math.acos(dot / (v1.length() * v2.length()));
        return theta;
    }

    public void debug() {
        System.out.println(String.valueOf(this.x) + ", " + this.y + ", " + this.z + ", " + this.w);
    }

    public String toString() {
        return new String(String.valueOf(this.x) + ", " + this.y + ", " + this.z + ", " + this.w);
    }
}

