/*
 * Decompiled with CFR 0.152.
 */
package megamu.mesh;

import megamu.mesh.MPolygon;
import quickhull3d.QuickHull3D;

public class Hull {
    int[] extrema;
    MPolygon region;

    public Hull(float[][] points) {
        if (points.length < 3) {
            this.extrema = new int[points.length];
            this.region = new MPolygon(points.length);
            int i = 0;
            while (i < points.length) {
                this.extrema[i] = i;
                this.region.add(points[i][0], points[i][1]);
                ++i;
            }
            return;
        }
        double[] qPoints = new double[points.length * 3 + 3];
        double avgX = 0.0;
        double avgY = 0.0;
        int i = 0;
        while (i < points.length) {
            qPoints[i * 3] = points[i][0];
            qPoints[i * 3 + 1] = points[i][1];
            qPoints[i * 3 + 2] = 0.0;
            avgX += (double)points[i][0];
            avgY += (double)points[i][1];
            ++i;
        }
        qPoints[qPoints.length - 3] = avgX / (double)(qPoints.length - 1);
        qPoints[qPoints.length - 2] = avgY / (double)(qPoints.length - 1);
        qPoints[qPoints.length - 1] = 1000.0;
        QuickHull3D quickHull = new QuickHull3D(qPoints);
        int[][] faces = quickHull.getFaces(9);
        int i2 = 0;
        while (i2 < faces.length) {
            boolean isFace = true;
            int j = 0;
            while (j < faces[i2].length) {
                if (faces[i2][j] == points.length) {
                    isFace = false;
                    break;
                }
                ++j;
            }
            if (isFace) {
                this.extrema = faces[i2];
                break;
            }
            ++i2;
        }
        this.region = new MPolygon(this.extrema.length);
        i2 = 0;
        while (i2 < this.extrema.length) {
            this.region.add(points[this.extrema[i2]][0], points[this.extrema[i2]][1]);
            ++i2;
        }
    }

    public int[] getExtrema() {
        return this.extrema;
    }

    public MPolygon getRegion() {
        return this.region;
    }
}

