/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class Planearium
extends PApplet {
    PImage img;
    PGraphics pg;
    int screen_w = 640;
    int screen_h = 360;
    int iter;
    float x;
    float y;
    float z;
    float offset_x;
    float offset_y;
    float persp_z;
    float avg_x;
    float avg_y;
    float avg_z;
    int col_r;
    int col_g;
    int col_b;
    float[] m = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    float[] p = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    int preset;
    int num_presets = 5;
    float[] p2 = new float[]{-0.653165f, -0.972152f, -0.713924f, -0.481f, 0.516458f, -0.592405f, -0.268f, 0.827f, 0.379747f, -0.943f, -0.072f, 1.2f, -0.47f, 0.041f, 0.0f, 0.914f, -0.531646f, 0.364557f, -0.333f, 0.29f, -0.815f, -1.127f, -0.479f, 1.049f, 0.857f, 0.252f, -0.772f, 1.066f, -0.384f, 0.26f, 0.296f, -0.655f, -0.832f, 0.118f, -1.098f, 0.059f, -0.325f, -1.158f, -0.448f, 0.229f, 0.042f, -0.85f, -0.349f, 1.048f, 1.063f, 0.319f, 0.865f, 0.507f, 0.168f, 0.353f, 0.584f, -0.043f, 0.903f, -0.876f, -0.076f, 0.251f, -0.294f, -0.83f, -0.951f, 0.755f, -0.782f, 0.645f, 0.828f, -0.932f, -0.504f, 0.794f, 1.034f, 0.078f, -0.344f, -0.39f, -0.078f, 0.511f, 1.099f, 0.07f, -0.53f, -0.657f, -0.646f, -0.414f, -1.062f, 0.494f, 0.016f, -0.863f, 1.008f, -0.057f, 0.331f, 1.046f, -0.587f, 0.07f, 0.176f, 0.511f};

    public void gen_params() {
        this.iter = 0;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.offset_x = this.random(this.screen_w / 2) - (float)(this.screen_w / 4);
        this.offset_y = this.random(this.screen_h / 5) - (float)(this.screen_h / 10);
        this.persp_z = this.random(1.0f) + 0.5f;
        this.avg_z = 0.0f;
        this.avg_y = 0.0f;
        this.avg_x = 0.0f;
        this.col_r = Planearium.round((float)(63.0f + this.random(192.0f)));
        this.col_g = Planearium.round((float)(63.0f + this.random(192.0f)));
        this.col_b = Planearium.round((float)(63.0f + this.random(192.0f)));
        float f = this.random(6.283185f);
        float f2 = this.random(6.283185f);
        this.m[0] = Planearium.cos((float)f);
        this.m[1] = 0.0f;
        this.m[2] = Planearium.sin((float)f);
        this.m[3] = Planearium.sin((float)f) * Planearium.sin((float)f2);
        this.m[4] = Planearium.cos((float)f2);
        this.m[5] = -Planearium.cos((float)f) * Planearium.sin((float)f2);
        this.m[6] = -Planearium.sin((float)f) * Planearium.cos((float)f2);
        this.m[7] = Planearium.sin((float)f2);
        this.m[8] = Planearium.cos((float)f) * Planearium.cos((float)f2);
        this.preset = Planearium.round((float)this.random(this.num_presets - 1));
        int n = 0;
        while (n < 18) {
            this.p[n] = this.p2[this.preset * 12 + n];
            ++n;
        }
    }

    public void setup() {
        this.size(this.screen_w, this.screen_h);
        this.background(0);
        this.pg = this.createGraphics(this.screen_w, this.screen_h, "processing.core.PGraphics2D");
        this.pg.background(0);
        this.gen_params();
    }

    public int clerp(int n, int n2, int n3, int n4) {
        return this.color(Planearium.min((int)255, (int)((n >> 16 & 0xFF) * n2 + (n3 >> 16 & 0xFF) * n4 >> 8)), Planearium.min((int)255, (int)((n >> 8 & 0xFF) * n2 + (n3 >> 8 & 0xFF) * n4 >> 8)), Planearium.min((int)255, (int)((n & 0xFF) * n2 + (n3 & 0xFF) * n4 >> 8)));
    }

    public int darken(int n, int n2) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = n3 - (n2 * n3 * n3 * n3 >> 24) - 1;
        n4 = n4 - (n2 * n4 * n4 * n4 >> 24) - 1;
        n5 = n5 - (n2 * n5 * n5 * n5 >> 24) - 1;
        return this.color(n3, n4, n5);
    }

    public void draw() {
        this.pg.beginDraw();
        this.pg.noFill();
        int n = 0;
        while (n < this.screen_w * this.screen_h) {
            this.pg.pixels[n] = this.darken(this.pg.pixels[n], 7);
            ++n;
        }
        ++this.iter;
        if (this.keyPressed || this.iter > 40) {
            this.gen_params();
        }
        int n2 = n = Planearium.round((float)this.random(17.0f));
        this.p[n2] = this.p[n2] + (this.random(0.01f) - 0.005f);
        this.p[12] = this.p[12] + 1.0E-4f;
        int n3 = 0;
        int n4 = 10000;
        int n5 = 0;
        while (n5 < n4) {
            float f = this.x;
            float f2 = this.y;
            float f3 = this.z;
            this.x = this.p[0] + f * (this.p[1] + this.p[2] * f + this.p[3] * f2) + f2 * (this.p[4] + this.p[5] * f2);
            this.y = this.p[6] + f2 * (this.p[7] + this.p[8] * f2 + this.p[9] * f3) + f3 * (this.p[10] + this.p[11] * f3);
            this.z = this.p[12] + f3 * (this.p[13] + this.p[14] * f3 + this.p[15] * f) + f * (this.p[16] + this.p[17] * f);
            float f4 = this.x * this.m[0] + this.y * this.m[1] + this.z * this.m[2];
            float f5 = this.x * this.m[3] + this.y * this.m[4] + this.z * this.m[5];
            float f6 = this.x * this.m[6] + this.y * this.m[7] + this.z * this.m[8];
            this.avg_x = Planearium.lerp((float)this.avg_x, (float)f4, (float)0.999f);
            this.avg_y = Planearium.lerp((float)this.avg_y, (float)f5, (float)0.999f);
            this.avg_z = Planearium.lerp((float)this.avg_z, (float)f6, (float)0.999f);
            float f7 = this.x * this.x + this.y * this.y + this.z * this.z;
            if (f7 < 1.0E-4f || f7 > 100.0f) {
                this.gen_params();
            }
            Planearium.round((float)(128.0f + 128.0f * this.z));
            int n6 = Planearium.round((float)((float)(this.screen_w / 2) + this.offset_x + 500000.0f * (f4 - this.avg_x) / (f6 - this.avg_z + this.persp_z)));
            int n7 = Planearium.round((float)((float)(this.screen_h / 2) + this.offset_y + 500000.0f * (f5 - this.avg_y) / (f6 - this.avg_z + this.persp_z)));
            if (n6 >= 0 && n6 < this.screen_w && n7 >= 0 && n7 < this.screen_h) {
                int n8 = n7 * this.screen_w + n6;
                int n9 = this.color(this.col_r, this.col_g, this.col_b);
                this.pg.pixels[n8] = this.clerp(this.pg.pixels[n8], 255, n9, 15);
                ++n3;
            }
            ++n5;
        }
        this.pg.endDraw();
        if (n3 < n4 / 3) {
            this.gen_params();
        }
        this.image((PImage)this.pg, 0.0f, 0.0f);
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#D4D0C8", "Planearium"});
    }
}

