import processing.core.*; 
import processing.xml.*; 

import java.applet.*; 
import java.awt.*; 
import java.awt.image.*; 
import java.awt.event.*; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class cubefractal extends PApplet {


float ax = 0;
float ay = 0;
float beat = 0;
int lit;

public void setup() 
{
  size(1024, 768,P3D);
  frameRate(30);
}

public void drawCubes(int level) 
{         
  float e = level*30 + (lit/3%5==level-1 && lit%3==0? 100 : 0);
  fill(e);
  box(80 + 30*sin(beat+level));
  
  if(level<=1) return;
  
  for(int a=0;a<6;a++)
  {
    pushMatrix();
    float t = (a%2==1) ? 1 : -1;
    t *= 100 + sin(cos(beat)*1.5f)*3;
    if(a/2==0) translate(t,0,0);
    if(a/2==1) translate(0,t,0);
    if(a/2==2) translate(0,0,t);
    scale(0.4f);
    drawCubes(level-1);
    popMatrix();
  }
}

public void draw()
{
  float b = sin(beat/8);
  background(255);
  lights();
  noStroke();
  translate(width/2,height/2);
  rotateX(ax);
  rotateY(ay);
  
  lit++;
  
  pushMatrix();
  ax += 0.4f*pow(0.5f+0.5f*sin(beat),5);
  ay += 0.51f*pow(0.5f+0.5f*sin(beat),5);
  beat += 0.7f;
  scale(3);
  drawCubes(5);
  popMatrix();
  
  for(int i=0;i<80;i+=2)
  {
    for(int j=-19;j<=19;j+=2)
    {
      pushMatrix();
      rotateX(i/80.f*2*3.141593f + beat*0.4f*( (i%4<2)?1:-1 ) );
      rotateY(j/80.f*2*3.141593f);
      translate(0,0,5000);
      fill(240);
      box(300);      
      popMatrix();
    }
  }

}


  static public void main(String args[]) {
    PApplet.main(new String[] { "--present", "--bgcolor=#666666", "--hide-stop", "cubefractal" });
  }
}
