
float ax = 0;
float ay = 0;
float beat = 0;
int lit;

void setup() 
{
  size(1024, 768,P3D);
  frameRate(30);
}

void drawCubes(int level) 
{         
  float e = level*30 + (lit/3%5==level-1 && lit%3==0? 100 : 0);
  fill(e);
  box(80 + 30*sin(beat+level));
  
  if(level<=1) return;
  
  for(int a=0;a<6;a++)
  {
    pushMatrix();
    float t = (a%2==1) ? 1 : -1;
    t *= 100 + sin(cos(beat)*1.5)*3;
    if(a/2==0) translate(t,0,0);
    if(a/2==1) translate(0,t,0);
    if(a/2==2) translate(0,0,t);
    scale(0.4);
    drawCubes(level-1);
    popMatrix();
  }
}

void draw()
{
  float b = sin(beat/8);
  background(255);
  lights();
  noStroke();
  translate(width/2,height/2);
  rotateX(ax);
  rotateY(ay);
  
  lit++;
  
  pushMatrix();
  ax += 0.4*pow(0.5+0.5*sin(beat),5);
  ay += 0.51*pow(0.5+0.5*sin(beat),5);
  beat += 0.7;
  scale(3);
  drawCubes(5);
  popMatrix();
  
  for(int i=0;i<80;i+=2)
  {
    for(int j=-19;j<=19;j+=2)
    {
      pushMatrix();
      rotateX(i/80.f*2*3.141593 + beat*0.4*( (i%4<2)?1:-1 ) );
      rotateY(j/80.f*2*3.141593);
      translate(0,0,5000);
      fill(240);
      box(300);      
      popMatrix();
    }
  }

}

