#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#ifdef DEB
#undef INITNOISE
#undef DRAWBACK
#define DRAWSVG
#define USERCONTROL
#undef FULLSCREEN
#define XRES 1024
#define YRES 768
#define CONVERTSTEP
#endif
#ifdef UNP
#define INITNOISE
#define DRAWBACK
#define DRAWSVG
#define USERCONTROL
#undef FULLSCREEN
#define XRES 1024
#define YRES 768
#endif
#ifdef REL
#define INITNOISE
#define DRAWBACK
#define DRAWSVG
#undef USERCONTROL
#define FULLSCREEN
#define XRES 1024
#define YRES 768
#endif

#define SVGXRES 1024
#define SVGYRES 768
#define SVGMULTISAMPLESHIFT 2
#define MSXRES (XRES<<SVGMULTISAMPLESHIFT)
#define MSYRES (YRES<<SVGMULTISAMPLESHIFT)
#define ASPECT ((float)XRES/(float)YRES)
#define VOXEL_SEED (39)
#define VOXEL_GRID_XBIT (11)
#define VOXEL_GRID_ZBIT (11)
#define VOXEL_GRID_X (1<<(VOXEL_GRID_XBIT))
#define VOXEL_GRID_Z (1<<(VOXEL_GRID_ZBIT))
#define VOXEL_PRE_SCALE_X (0.00015f)
#define VOXEL_PRE_SCALE_Z (0.00015f)
#define VOXEL_SIZE_X (10000.f)
#define VOXEL_SIZE_Z (10000.f)
#define VOXEL_STEP_X ((float)VOXEL_SIZE_X/(float)VOXEL_GRID_X)
#define VOXEL_STEP_Z ((float)VOXEL_SIZE_Z/(float)VOXEL_GRID_Z)
#define VOXEL_HEIGHT 800.f

#include <windows.h>
#include <mmsystem.h>

#include "math.hpp"
#include "ridged.hpp"
#include "vectorconvert.hpp"
#include "svgart.hpp"

VEC4 lightpos(0,0,2000);

//----------------------------------------------------------------------------

static const BITMAPINFO bmi = {{sizeof(BITMAPINFOHEADER),XRES,-YRES,1,32,BI_RGB,0,0,0,0,0},{0,0,0,0}};
static DEVMODE screenSettings = { {0},
    #if _MSC_VER < 1300 // 1300 fits better (iq 1400)
    0,0,148,0,0x001c0000,{0},0,0,0,0,0,0,0,0,0,{0},0,32,XRES,YRES,0,0,      // Visual C++ 6.0
    #else
    0,0,156,0,0x001c0000,{0},0,0,0,0,0,{0},0,32,XRES,YRES,{0}, 0,           // Visuatl Studio 2005
    #endif
    #if(WINVER >= 0x0400)
    0,0,0,0,0,0,
    #if (WINVER >= 0x0500) || (_WIN32_WINNT >= 0x0400)
    0,0
    #endif
    #endif
    };

extern "C" { int _fltused = 0; 
}

//----------------------------------------------------------------------------
static unsigned int buffer[XRES*YRES] = { 0 };
static unsigned char EorBuffer[MSXRES*MSYRES] = { 0 };
static unsigned int EorBufferDest[MSXRES*MSYRES] = { 0 };
static float voxel[VOXEL_GRID_X*VOXEL_GRID_Z];
//----------------------------------------------------------------------------
float GetVoxelHeightXZ(const VEC4 &p)
{
  const float xr=p.x/VOXEL_STEP_X;
  const float zr=p.z/VOXEL_STEP_Z;
  int xv = efloor(xr);
  int zv = efloor(zr);
  const float xn=xr-(float)xv;
  const float zn=zr-(float)zv;
  const int a = (zv<<VOXEL_GRID_XBIT)+xv;
  const float h1 = voxel[(a) & (VOXEL_GRID_X*VOXEL_GRID_Z-1)];
  const float h2 = voxel[(a+1) & (VOXEL_GRID_X*VOXEL_GRID_Z-1)];
  const float h3 = voxel[(a+VOXEL_GRID_Z) & (VOXEL_GRID_X*VOXEL_GRID_Z-1)];
  const float h4 = voxel[(a+1+VOXEL_GRID_Z) & (VOXEL_GRID_X*VOXEL_GRID_Z-1)];
  return elerp(elerp(h1,h2,xn),elerp(h3,h4,xn),zn)*VOXEL_HEIGHT;
}

bool castRay(const VEC4 &ro, const VEC4 &rd, float &resT, const float maxlen, const float increase)
{
    float delt = .005f;
    float lh = 0.0f;
    float ly = 0.0f;
    VEC4 p=ro;
    VEC4 a(0);
    a.AddScale(rd,delt/increase);
    for( float t = 0; t < maxlen; t += delt )
    {
        p.x+=a.x*=increase;
        p.y+=a.y*=increase;
        p.z+=a.z*=increase;
        const float h = GetVoxelHeightXZ(p);
        if( p.y < h )
        {
            resT = t - delt + delt*(lh-ly)/(p.y-ly-h+lh);
            return true;
        }
        delt*=increase;
        lh = h;
        ly = p.y;
    }
    return false;
}

VEC4 GetNormal(VEC4 p)
{
  float h1=GetVoxelHeightXZ(p);
  p.x+=VOXEL_STEP_X;
  float h2=GetVoxelHeightXZ(p);
  p.z+=VOXEL_STEP_Z;
  float h3=GetVoxelHeightXZ(p);
  VEC4 nrm(h2-h1,.1f,h3-h1);  
  nrm.Unit3();
  return nrm;
}

VEC4 GetSkyColor(const VEC4 &nrm)
{
  VEC4 grad0(0.96f,0.53f,0.12f);
  VEC4 grad1(0.25f,0.31f,0.48f);
  VEC4 PA,PB;
  PA.Init(0.125f,0.15f,0.1f,0);
  float y = (1-nrm.y)*0.5f;
  PA.x*=1.f+y*4.f;
  PA.y*=1.f+y*2.f;
  PA.z*=1.f+y*4.f;
  VEC4 skyv;
  skyv.Init();
  skyv.AddScale(nrm,6000);
  skyv.x /= skyv.y*0.00055f+1;
  skyv.z /= skyv.y*0.00055f+1;
  skyv.y = 0;
  skyv.x *= 0.001f;
  skyv.z *= 0.001f;
  float cloudin1=RMFractal(skyv);
  VEC4 cloudcol(2.2f,0.9f,0.25f);
  PB.lerp3(grad1,grad0,(y-0.5f)*1.25f);
  if (y<0.5f)
  {
    PA.lerp3(PA,cloudcol,eclamp(-cloudin1*0.5f+nrm.y,0,1));
    PB.lerp3(grad0,grad1,y*2.f);
  }
  PA.Colorize(PA,PB,1.f);
 
  return PA;
}

VEC4 GetRay(const VEC4 &origin, const VEC4 &nrm)
{
  VEC4 hp,hnrm;
  float dist;

  const float maxsiz=10000;
  const float deptha=1.25f;
  // Landscape
  if (castRay(origin,nrm,dist,maxsiz,deptha))
  {
    // calculate hitpoint
    hp=origin;
    hp.AddScale(nrm,dist);
    hp.y=GetVoxelHeightXZ(hp);

    // get normal at hitpoint
    hnrm=GetNormal(hp);

    // shadow pass
    VEC4 lsp,ldir;
    float distL;
    lsp = hp;
    lsp.y += 0.0001f;
    //ldir = lightpos;ldir.AddScale3(lsp,-1);ldir.Unit3();
    ldir.Init(1,1,0);ldir.Unit3();
    bool shadow=castRay(lsp,ldir,distL,200,1.15f);

    // calculate light here
    VEC4 light,mountain;
    light.Init(1.f,1.f,1.f);
    mountain.Init(0.3f,0.5f,0.2f);
    VEC4 curcol;
    curcol.lerp3(light,mountain,eclamp(edot3(hnrm,ldir),0,1));
    if (shadow)
      curcol.scale3(0.75f);
    curcol.scale3(1.f+hp.y*0.001f);
    curcol.Colorize(curcol,GetSkyColor(nrm),0.5f);
    return curcol;
  }
  return GetSkyColor(nrm);
}

int PenOn[8]={0};

void Line(int xp1,int yp1,int xp2,int yp2, unsigned char colorbit)
{
  int x1 = (int)(eclamp((float)xp1 * blowUpFactorX,0,MSXRES-1));
  int x2 = (int)(eclamp((float)xp2 * blowUpFactorX,0,MSXRES-1));
  int y1 = (int)((float)yp1 * blowUpFactorY);
  int y2 = (int)((float)yp2 * blowUpFactorY);
  int lx = x2 - x1;
  int ly = y2 - y1;
  int l=eabs(ly);
  int yp = y1;
  int ya = l!=0?ly/l:0;
  int xp = x1 << 12;
  int xa = l!=0?(lx << 12)/l:0;
  if (ya>0)
    yp+=ya;
  for (int i = 0; i < l; ++i)
  {
    int adr = (xp>>12) + yp * MSXRES;
    if ((unsigned int)yp<MSYRES)
      EorBuffer[adr]^=colorbit; 
    xp+=xa;
    yp+=ya;
  }
}

#ifdef K4 // K4
#ifdef DEB
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
#endif
#ifdef UNP
extern "C" __declspec(noreturn) void WinMainCRTStartup()
#endif
#ifdef REL
extern "C" __declspec(noreturn) void WinMainCRTStartup()
#endif
#endif // K4

#ifdef VBK // VBK
#ifdef DEB
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
#endif
#ifdef UNP
WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
#endif
#ifdef REL
extern "C" __declspec(noreturn) void WinMainCRTStartup()
#endif
#endif // VBK

{
#ifdef FULLSCREEN
  if( ChangeDisplaySettings(&screenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL) ExitProcess(0);
  ShowCursor( 0 );
#endif

  HWND hWnd;
  HDC hDC = GetDC( hWnd=CreateWindowEx( WS_EX_TOPMOST, "static", 0, WS_VISIBLE|WS_POPUP|WS_CLIPSIBLINGS|WS_CLIPCHILDREN, 0, 0, XRES, YRES, 0, 0, 0, 0 ) );
#ifdef CONVERTSTEP
  ConvertSVG("vectorstuff/citycen1.svg");
#endif

#ifdef INITNOISE
  init_noise();

  float *d=voxel;
  VEC4 t(0,0,0);
  for (int x=0;x<VOXEL_GRID_X;++x)
  {
    t.z=0.f;
    for (int z=0;z<VOXEL_GRID_Z;++z)
    {
      *d++=RMFractal(t);
      t.z+=VOXEL_STEP_Z*VOXEL_PRE_SCALE_Z;
    }
    t.x+=VOXEL_STEP_X*VOXEL_PRE_SCALE_X;
  }
#endif

#ifdef DRAWBACK
  VEC4 orig(5200,130,100);
  orig.y=GetVoxelHeightXZ(orig)+17.5f;
  unsigned int *b=buffer;
  for (int y=0;y<YRES;++y)
  for (int x=0;x<XRES;++x)
  {
    VEC4 nrm((float)(x-XRES/2)/(float)(XRES/2)*ASPECT,-(float)(y-YRES/2)/(float)(YRES/2),.85f);
    nrm.Unit3();
    *b++=GetRay(orig,nrm).GetColor();
  }
#endif

#ifdef DRAWSVG
  // draw picture line onehand of data
  short *path = PathData;
  while(*path!=0x1ace)
  {
    int pathBits=path[0];
    path+=1;
    int x = path[0];
    int y = path[1];
    path+=2;
    while(*path!=0x4000)
    {
      int x2 = x + path[0];
      int y2 = y + path[1];
      Line(x,y,x2,y2,1<<pathBits);
      x = x2;
      y = y2;
      path+=2;
    }
    path++;
  }

  // build picture with line information / eorbuffer
  int currentadr = 0;
  float fog = 0;

  while (currentadr<MSXRES*MSYRES)
  {
    for (int i = 0; i < PENCOUNT; ++i)
      if (EorBuffer[currentadr] & (1<<i))
        PenOn[i] ^= 1;

    int currentX = currentadr % MSXRES;
    int currentY = currentadr / MSXRES;
    int currentBufferI = (currentX>>SVGMULTISAMPLESHIFT) + (currentY>>SVGMULTISAMPLESHIFT)*XRES;
    VEC4 cur;cur.InitColor(buffer[currentBufferI]);
    if (efrand()>0.975f)
      fog=RMFractal(VEC4((float)currentX/(float)MSXRES*2.f,0,(float)currentY/(float)MSYRES/4.f))+0.4f;
    for (int i = 0; i < PENCOUNT; ++i)
    {  
      if (PenOn[i])
      {
        VEC4 pen;
        pen.InitColor(PencilColors[i]);
        VEC4 Fogging(fog*0.6f,fog*0.5f,fog*0.4f);
        pen.AddScale(Fogging,1.f);
        cur.lerp3(cur,pen,1.f-fog * 0.25f);
      }
    }
    EorBufferDest[currentadr]=cur.GetColor();
    currentadr++;
  }
  // fill final picture with multisampling
  int i=0;
  for (int y = 0; y < YRES;++y)
  for (int x = 0; x < XRES;++x)
  {
    VEC4 col;
    col.Init(0);
    for (int y2 = 0; y2 < 1<<SVGMULTISAMPLESHIFT;++y2)
    for (int x2 = 0; x2 < 1<<SVGMULTISAMPLESHIFT;++x2)
    {
      VEC4 col2;
      col2.InitColor(EorBufferDest[((x<<SVGMULTISAMPLESHIFT)+x2)+((y<<SVGMULTISAMPLESHIFT)+y2)*MSXRES]);
      col.AddScale(col2,1.f/(float)((1<<SVGMULTISAMPLESHIFT)*(1<<SVGMULTISAMPLESHIFT)));
    }
    buffer[i]=col.GetColor();
    ++i;
  }
#endif

  do
  {
	  StretchDIBits(hDC,0,0,XRES,YRES,0,0,XRES,YRES,buffer,&bmi,DIB_RGB_COLORS,SRCCOPY);
#ifdef USERCONTROL
    MSG		msg;
		if (PeekMessage(&msg, hWnd, 0,0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
#endif
  }while( !GetAsyncKeyState(VK_ESCAPE));
}
