attribute vec3 va_position, va_normal;

uniform mat4 mat_sun_view2uv, mat_view2world;
uniform float animateSlider;

varying vec3 posVS, posWS, normalVS, normalWS;
varying vec4 sunUV;

float height(vec3 pos, float t) {
	return 1.0+0.03*(sin(pos.x*15.0+t*1.0)*cos(pos.z*16.0-t*1.0)+sin(pos.y*13.4)*cos(pos.x*16.5+1.2*t*1.0));
}

void main(void)
{
	vec3 pos_before = va_position;

	float ch = height(pos_before, animateSlider);
	
	vec3 posOS = va_position * ch;
	
	float eps = 0.001;
	vec3 dx = vec3(1.0, height(pos_before+vec3(eps,0.0,0.0), animateSlider), 0.0);
	vec3 dz = vec3(0.0, height(pos_before+vec3(eps,0.0,0.0), animateSlider), 1.0);
	vec3 nor = -normalize(cross(dx, dz));
	
	vec3 temp_posVS    = (gl_ModelViewMatrix * vec4(posOS, 1.0)).xyz;
	vec3 temp_normalVS = gl_NormalMatrix     * nor;
	
	posVS    = temp_posVS;
	normalVS = temp_normalVS;
	
	posWS    = (mat_view2world  * vec4(temp_posVS,    1.0)).xyz;
	normalWS = (mat_view2world  * vec4(temp_normalVS, 0.0)).xyz;
	sunUV    =  mat_sun_view2uv * vec4(temp_posVS,    1.0);

	gl_Position = gl_ModelViewProjectionMatrix * vec4(posOS, 1.0);
	gl_FrontColor  = vec4( gl_Color.rgb * (0.6+0.4*(ch-1.0)/0.03), 1.0);
}
