uniform float sun_ymin, sun_ymax;
varying float worldY;

const vec4 packFactors = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0);
const vec4 bitMask = vec4(0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);

vec4 pack( float rawValue ) {
	vec4 packedValue = vec4(fract(packFactors*rawValue));
	packedValue -= packedValue.xxyz * bitMask;
	return packedValue;
}

void main() {
	float saveMe = min(max((worldY-0.4-sun_ymin)/(sun_ymax-sun_ymin), 0.0), 1.0);
	gl_FragColor = pack(saveMe);
}
