attribute vec3  va_pos;
attribute vec2  va_displacement;
attribute float va_radius;
attribute vec4  va_color;
uniform vec4 buffycolly;
uniform mat4 mat_view2world;

uniform vec4 color;

uniform vec3 cameraRight, cameraUp;

void main(void) {

	float a = va_pos.x*1234.5;
	float sa = sin(a);
	float ca = cos(a);
	vec2 d = va_displacement;
	vec3 posOS = va_pos + va_radius * ((d.x*ca+d.y*sa) * cameraRight + (-d.x*sa+d.y*ca) * cameraUp);
	
	gl_TexCoord[0].st = va_displacement * 0.5 + 0.5;	
	gl_Position   = gl_ModelViewProjectionMatrix * vec4(posOS, 1.0);
	color = va_color * buffycolly;
}
