program game;

uses crt, sysUtils;

const
  Left  = 75;
  Right = 77;
  Up    = 72;
  Down  = 80;

type
  TPosedChar = record
		      x,y:integer;
		      c:char;
	            end;

  TFrame  = object
               image: array of TPosedChar ;
               width,height:integer;
	       procedure loadFromFile (data:string);
	       procedure draw (x,y:integer; hidden:boolean);
            end ;

  TPlayer = object
		x,y,maxx,maxy:integer;
		frames:array of TFrame;
		currentFrame:integer;
		procedure onKeyPress (c:char);
		procedure draw (hidden:boolean);
		procedure addFrame (f:string);
	    end;

var
  c:char;
  lives:integer;

var
  player:TPlayer;
  enemies : array of TPlayer;


procedure TFrame.loadFromFile (data:string);
var
  i,j:integer;
  s:string;
  t:text;
begin
  assign (t,data);
  reset (t);
  width:=0;
  height:=0;
  i:=0; j:=0;
  while not eof(t) do
  begin
    readln(t,s);
    for i:=1 to length(s) do
    begin
      setlength(image, length(image)+1);
      image[length(image)-1].x := i-1;
      image[length(image)-1].y := j;
      image[length(image)-1].c := s[i];
      if (i>width) then width:=i;
      if (j>height) then height:=j;
    end;
    j:=j+1;
  end;
  close (t);
end ;

procedure TFrame.draw (x,y:integer; hidden:boolean);
var
  i:integer;
begin
  if (hidden) then
    textcolor(0)
  else
    textcolor(15);
  for i:=0 to length (image)-1 do
  begin
    gotoxy(x+image[i].x,y+image[i].y);
    write(image[i].c);
  end;
end;

procedure TPlayer.onKeyPress (c:char);
var
  i,j:integer;
begin
  case ord(c) of
    up   : y:=y-1;
    down : y:=y+1;
    left : x:=x-1;
    right: x:=x+1;
    32   : begin
             for i:=y-1 downto 4 do
             begin
               gotoxy (x+frames[0].width div 2,i);
               write ('*');
               for j:=0 to length(enemies)-1 do
               begin
                 if (x>enemies[j].x-10) and (x+frames[0].width<enemies[j].x+enemies[j].frames[0].width) then
                 begin
		    enemies[j].y := -1*random(30);
		    enemies[j].x := random(enemies[j].maxx);
                 end;
               end;
             end;
           end;
  end;
end;

procedure TPlayer.draw(hidden:boolean);
begin
  frames[0].draw (x,y,hidden);
end;

procedure TPlayer.addFrame(f:string);
begin
  setlength(frames,length(frames)+1);
  frames[length(frames)-1].loadFromFile(f);
end;


procedure createEnemies(n,maxx,maxy:integer);
var
  i:integer;
begin
  randomize;
  setlength(enemies,n);
  for i:=0 to n-1 do
  begin
    enemies[i].addFrame('enemy.txt');
    enemies[i].y := -1*random(maxy)-1;
    enemies[i].x := random(maxx)-5;
    enemies[i].maxx := maxx;
    enemies[i].maxy := maxy;
    ENEMIES[I].currentFrame := 0;
  end;
end;

procedure drawEnemies(hidden:boolean);
var
  i:integer;
begin
  for i:=0 to length(enemies)-1 do
  begin
    if enemies[i].y>0 then
    enemies[i].draw(hidden);
  end;
end;

procedure proceedEnemies;
var
  i:integer;
begin
  for i:=0 to length(enemies)-1 do
  begin
    enemies[i].y:=enemies[i].y+1;
    if (player.x>enemies[i].x) and
       (player.x<enemies[i].x+enemies[i].frames[0].width) and
       (player.y=enemies[i].y) then
    begin
       dec(lives);
       if (lives<0) then
       begin
       clrscr;
       writeln ('Game Over!');
         halt (0);
       end;
    end;
    if (enemies[i].y>enemies[i].maxy) then
    begin
      enemies[i].y := -1*random(30);
      enemies[i].x := random(enemies[i].maxx);
    end;
  end;
end;

begin
  clrscr ;
  textcolor(15);
  lives:=10;
  player.addFrame('player_up.txt');
  player.y := 20;
  player.x := 40;
  player.maxy := 40;
  player.maxx := 50;
  player.draw(false);
  player.currentFRAME  := 0;

  createEnemies(10,70,40);
  drawEnemies  (false);
  repeat
    delay (60);
    if keypressed then
    c:=readkey;

    clrscr;
    textcolor(4);
    gotoxy(0,0);
    write(lives);
    textcolor(15);
    //player.draw(true);
    player.onKeyPress(c);
    player.draw(false);
    //drawEnemies(true);
    proceedEnemies;
    drawEnemies(false);

  until ord(c) = 27;
end.
