/*
* PlotterSample.fx
 *
 * Created on 05.05.2009, 20:42:16
 */

package samples.mathematics.plotter;


/**
 * @author Alexandr Scherbatiy
 */

import javafx.stage.*;
import javafx.scene.*;
import javafx.scene.transform.*;
import mathematics.multidimensional.shape.*;
import mathematics.multidimensional.dim2.*;
import mathematics.multidimensional.dim3.*;


Stage {
    title: "Paraboloid"
    scene: Scene {
        width: 300
        height: 300
        content: [
            MDUniversePlayer{
                dimension: 3
                autoplay: true
                transforms: Transform.translate(150,150);

                shapes: MDPlotter{
                    mdtransform: SurfaceDim3 {
                        z: function(u:Number, v:Number):Number{ (u * u + v * v) / 70 - 50}
                    }
                    domain: ParametrizedSetDim2{
                        delta: 10.0
                        startPointX: -75
                        startPointY: -57
                        endPointX: 75
                        endPointY: 75
                    }
                }
            }
        ]
    }
}