/*
 * Switch.fx
 *
 * Created on Aug 6, 2009, 5:49:01 PM
 */

package physics.electronic;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;

import javafx.util.Math;

/**
 * @author andromeda
 */

//  ============  Switch ====================//




public class Switch extends ElectronicComponent{

    override var name = "Switch";

    public var switchOn: Boolean = false;
    
    override var pin1 on replace oldPin=newPin {
        pin1.pos = XY{x: bind pos.x + compWidth   y: bind pos.y };
    }
    override var pin2 on replace oldPin=newPin {
        pin2.pos = XY{x: bind pos.x - compWidth   y: bind pos.y };
    }


    override function simulate():Void{
      if(switchOn){
        switchLevels();
      }
    }

    override function create(): Node{
      return Group{
        content:  [ Circle{
            centerX: bind pos.x
            centerY: bind pos.y
            radius:  Math.min(compWidth, compHeight)
            fill: Color.ORANGE
            stroke: Color.BROWN
            onMouseClicked: function(e){
                switchOn = not switchOn;
            }
            onMouseDragged: function(e:MouseEvent){
                pos.x = e.x;
                pos.y = e.y;
            }
        }, Group{
            content: bind if (switchOn) then Line{
              startX: bind pos.x - compWidth
              startY: bind pos.y
              endX: bind pos.x + compWidth
              endY: bind pos.y
              stroke: Color.BROWN
              strokeWidth: 2
          } else Line{
              startX: bind pos.x - compWidth / 1.7
              startY: bind pos.y + compHeight /1.7
              endX: bind pos.x + compWidth / 1.7
              endY: bind pos.y - compHeight /1.7
              stroke: Color.BROWN
              strokeWidth: 2
          }
        } ,pin1, pin2]

      };
    }

}
