/*
 * Lamp.fx
 *
 * Created on Aug 6, 2009, 5:47:59 PM
 */

package physics.electronic;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;

import javafx.util.Math;

/**
 * @author andromeda
 */

//  ============  Lamp ====================//


public class Lamp extends ElectronicComponent{

    override var name = "Lamp";

    public var switchOn: Boolean = false;
    
    override var pin1 on replace oldPin=newPin {
       pin1.pos = XY{x: bind pos.x - compWidth / 2  y: bind pos.y + 2 * compHeight -5};
    }

    override var pin2 on replace oldPin=newPin {
      pin2.pos = XY{x: bind pos.x + compWidth / 2  y: bind pos.y + 2 * compHeight - 5};
    }


    override function simulate():Void{
      if( Math.abs( pin1.level - pin2.level) > 5 ){
        switchOn = true;
      }else{
        switchOn = false;
      }
     switchLevels();
    }

    override function create(): Node{
      var r = Math.min(compWidth, compHeight);
      var h = r / 2.0;

      return Group{
        content: [Rectangle{
            x: bind pos.x - h
            y: bind pos.y
            width: r
            height: 2* r
            fill: Color.SILVER
        }, Circle{
            centerX: bind pos.x
            centerY: bind pos.y
            radius: r
            fill: bind if (switchOn) then Color.RED else Color.GREY
        }, pin1, pin2 ]
        onMouseDragged: function (e: MouseEvent){
            pos.x = e.x;
            pos.y = e.y;
         }
      };
    }


}
