/*
 * CelestialBodySystem.fx
 *
 * Created on 07.05.2009, 19:07:15
 */

package physics.classical.object;

/**
 * @author Alexandr Scherbatiy
 */

import javafx.util.Math;


import javafx.scene.*;
import javafx.scene.text.*;
import javafx.scene.paint.*;
import javafx.scene.shape.*;


class Scale{
    package var radiusScale: Number;
    package var coordinateScale: Number;
}

public class PhysicalObjectSystem extends CustomNode{
    
    public var dt: Number = 60* 60 * 24 * 2;
    public var G: Number = 6.67e-11;
    public var objects:  PhysicalObject[];

    package var scale: Scale = Scale{ coordinateScale:  100.0/150e9 radiusScale: 20.0/14000.0};

    public function run():Void{

        for(obj1 in objects){
            
            obj1.acceleration.zero();

            for(obj2 in objects[obj| obj!= obj1]){
                var distance = obj2.coordinate.sub(obj1.coordinate);
                obj1.acceleration = obj1.acceleration.add(distance.normal().mul(G * obj2.mass / distance.square() ))
            }
        }

        for(obj in objects){
            obj.velocity   = obj.velocity.add( obj.acceleration.mul( dt) );
            obj.coordinate = obj.coordinate.add( obj.velocity.mul( dt ));
        }
    }


    override function create():Node{
        Group{
            content: bind for(obj in objects)
            Group{
                content: [
                    Circle{
                        centerX: bind obj.coordinate.elems[0] * scale.coordinateScale
                        centerY: bind obj.coordinate.elems[1] * scale.coordinateScale
                        radius: obj.radius * scale.radiusScale
                        fill: obj.color
                    },
                    Text{
                        content: obj.name
                        font: Font {name: "BOLD" size: 16}
                        x: bind obj.coordinate.elems[0] * scale.coordinateScale + 15
                        y: bind obj.coordinate.elems[1] * scale.coordinateScale - 15
                        strokeWidth: 3
                        fill: Color.WHITE
                    }
                ]
            }
        };
    }
}
