/*
 * VectorDim3.fx
 *
 * Created on 07.05.2009, 22:23:33
 */

package mathematics.multidimensional.dim3;

/**
 * @author Alexandr Scherbatiy
 */

import mathematics.multidimensional.*;

public class VectorDim3 extends MDVector{
    public override var dim = 3;



    public function add(v:VectorDim3):VectorDim3{
        VectorDim3{
            elems: for(n in [0..dim-1]) elems[n] + v.elems[n]
        }
    }


    public function sub(v:VectorDim3):VectorDim3{
        VectorDim3{
            elems: for(n in [0..dim-1]) elems[n] - v.elems[n]
        }
    }

    override function mul(a:Number):VectorDim3{
        VectorDim3{
            elems: for(n in [0..dim-1]) a * elems[n]
        }
    }

    override function normal():VectorDim3{
        mul(1.0 / length() )
    }

}
