package mathematics.multidimensional;

/**
 * @author Alexandr Scherbatiy
 */


public class MDVector extends AMDVector, ICMDVector{

    public var dim: Integer ;
    public var elems: Number[];

    public var metric:IMDSquareTransform = MDIdentity{ dim: dim };

    override function getDim(){ dim };
    override function getElem(n: Integer):Number{ elems[n] }
    override function setElem(n: Integer, value:Number){ elems[n] = value }
    override function getMetric(){ metric }

    override function zero(){
        for( n in [0..dim-1]) elems[n] = 0;
    }

    override function getCVector():ICMDVector{
        MDVector{
            dim: dim
            elems: for (elem in elems) elem
        }
    }

}


public function getDim(vector1: IMDVector, vector2: IMDVector):Number {
    vector1.getDim();
}
public function getElems(vector: IMDVector):Number[] {
    for( i in [0..vector.getDim()-1]) vector.getElem(i)
}

public function getElems(index1:Integer, index2:Integer, vector: IMDVector):Number[] {
    
    for( i in [index1..index2]) vector.getElem(i)
}

public function getCVector(vector:IMDVector):ICMDVector{
        var dim = vector.getDim();
        MDVector{
            dim: dim
            elems: for (n in [0..dim -1]) vector.getElem(n)
        }
}

public function getNeighborhood(delta:Number, vector: IMDVector):IMDVector[] {

var dim = vector.getDim();
    
    for(n in [0..dim-1]){

        var slice1 = getElems(  0,   n-1, vector);
        var slice2 = getElems(n+1, dim-1, vector);
        var elem = vector.getElem(n);
        [
            MDVector{ dim: dim,  elems: [slice1, elem + delta, slice2] },
            MDVector{ dim: dim,  elems: [slice1, elem - delta, slice2] }
        ]

    }

}

public function getPositiveNeighborhood(delta:Number, vector: IMDVector):IMDVector[] {

    var dim = vector.getDim();

    for(n in [0..dim-1]){
            MDVector{ dim: dim,  elems: [getElems(  0,   n-1, vector), vector.getElem(n) + delta, getElems(n+1, dim-1, vector)] }
    }

}


