/*
 * MDIdentity.fx
 *
 * Created on 07.05.2009, 23:51:39
 */

package mathematics.multidimensional;

/**
 * @author Alexandr Scherbatiy
 */


var N = 16;

var instances = for(n in [0..N-1]) MDIdentity{ dim: n }

public function getInstance(dim:Integer):MDIdentity{
    if( dim < N ){ instances[dim] } else { MDIdentity{ dim: dim } };

}

public class MDIdentity extends AMDSquareMatrix{


    override function getElem(n:Integer, m:Integer) {
        if( n == m ) { 1 } else { 0 }
    }

    override function transform (vector:IMDVector):IMDVector {
        return vector;
    }

     public override function mul(transform:IMDSquareTransform):IMDSquareTransform{
         return transform;
     }


     public override function innerProduct(v1:IMDVector, v2:IMDVector):Number{
         var s = 0.0;

         for(n in [0..dim-1]){
            s += v1.getElem(n) * v2.getElem(n);
         }

         return s;
     }


//    override function getCMatrix():ICMDSquareMatrix {
//        MDSquareMatrix.getCMatrix(this);
//    }


    override function toString ():String { "MDIdentity\{ dim: {dim} \}"  }

}
