package mathematics.multidimensional;

/**
 * @author Alexandr Scherbatiy
 */

import javafx.util.Math;

public mixin class AMDVector extends IMDVector{

    override function length():Number{ Math.sqrt(square()) }

    override function square():Number{ 
        getMetric().innerProduct(this,this);
    }

    override function normal():IMDVector{ mul(1.0 / length()) }
    
    override function innerProduct(v:IMDVector):Number{ getMetric().innerProduct(this, v) }


    override function add(v:IMDVector):IMDVector{
        MDVector{
            dim: getDim()
            elems: for(n in [0..getDim()-1]) getElem(n) + v.getElem(n)
        }
    }
    override function sub(v:IMDVector):IMDVector{ 
        MDVector{
            dim: getDim()
            elems: for(n in [0..getDim()-1]) getElem(n) - v.getElem(n)
        }
    }

    override function mul(a:Number):IMDVector{
        MDVector{
            dim: getDim()
            elems: for(n in [0..getDim()]) a * getElem(n)
        }
    }

    override function subVector(dim:Integer):IMDVector{
        MDVector{
            dim: dim
            elems: for(n in [0..dim - 1]) getElem(n)
        }
    }


    //override function equals () {  }

    override function toString ():String { "[ {for(n in [0..getDim()-1]) "{getElem(n)} " } ]" }

}

