/*
 * AMDSquareMatrix.fx
 *
 * Created on Jul 31, 2009, 1:42:28 PM
 */

package mathematics.multidimensional;

/**
 * @author andromeda
 */

//public mixin class AMDSquareMatrix extends AMDSquareTransform, IMDSquareMatrix {
public mixin class AMDSquareMatrix extends AMDSquareTransform, IMDSquareMatrix {
//public mixin class AMDSquareMatrix extends AMDMatrix, AMDSquareTransform, IMDSquareMatrix {


    override function transform (vector:IMDVector):IMDVector {
        mul(vector);
    }


    override function mul (vector:IMDVector):IMDVector {

        MDVector{
            dim: dim
            elems: for( n in [0 ..dim - 1]){
                var elem = 0.0;
                for( m in [0..dim - 1]){
                    elem += getElem ( n, m ) * vector.getElem(m);
                }
                elem
            }


        }

    }


    override function determinant():Number{

        if(dim == 1){
            return getElem(0, 0);
        }else{

           var det = 0.0;
           var sign = 1;
           for(i in [0..dim-1]){
                det += sign * getElem(0,i) * drop(0,i).determinant();
                sign = -sign;
           }

           return det;
       }
    }



    override function drop(n:Integer, m:Integer):IMDSquareMatrix{
        MDSquareMatrix{
            dim: dim - 1
            elems: for(i in [[0..n-1], [n+1..dim-1]]){
                        for(j in [[0..m-1], [m+1..dim-1]]){
                                getElem(i, j);
                        }
                    }
        }

    }

    override function getRow(n:Integer):IMDVector{
            MDMatrix.getRow(n, this)
    }


    override function getColumn(m:Integer):IMDVector{
            MDMatrix.getColumn(m, this)
    }

    override function getCMatrix():ICMDMatrix {
        MDMatrix.getCMatrix(this);
    }


    override function getCSquareMatrix():ICMDSquareMatrix {
        MDSquareMatrix.getCSquareMatrix(this);
    }



    override function toString():String {
        "Square Matrix\{ dim: {dim}  elems: {for(n in [0..dim-1]) "[ {for(m in [0..dim-1]) "{getElem(n,m)} "}]" } \}"
    }

}
