/*
 * CoordinatsView.fx
 *
 * Created on 08.08.2009, 11:09:41
 */

package mathematics.function;

/**
 * @author raindrop
 */

import javafx.scene.*;
import javafx.scene.text.*;
import javafx.scene.paint.*;
import javafx.scene.shape.*;

public class CoordinatsView extends CustomNode{

    public var xMin: Number;
    public var xMax: Number;
    public var scale: Number;
    public var interval: Number;
    public var color: Color = Color.GREEN;


    public var content: Node[];

    override function create():Node{

      var dh = 25;

      var min = xMin * scale - dh;
      var max = xMax * scale + dh;
      var h = 7;

      var gridColor = Color.LIGHTGREY;

      Group{
        content:[
            Group{
                scaleY: -1
                content: [                    
                    if(interval == 0.0) then [
                        Text{ x: xMin * scale y: -3 content: "{xMin}" },
                        Text{ x: xMax * scale y: -3 content: "{xMax}"}
                    ] else [
                        for(x in [xMin..xMax step interval],  p in [x * scale] )[
                            Line{ 
                                startX: min startY: p
                                endX: max   endY: p
                                stroke: gridColor
                            }
                            Line{
                                startX: min startY: p 
                                endX: max   endY: p 
                                stroke: gridColor
                            }
                            Line{
                                startX: p startY: min
                                endX: p   endY: max
                                stroke: gridColor
                            }
                            
                            Circle{ centerX: p radius: 2 fill: color }
                            Circle{ centerY: p radius: 2 fill: color }

                            Text{ x: p - 10 y: -3 content: "{x}" }
                            Text{ x: 3  y: -p content: "{x}"}
                            
                         ]
                    ],
                    Line{ startX: min endX: max stroke: color },
                    Line{ startX: max endX: max - h endY: h stroke: color },
                    Line{ startX: max endX: max - h endY: -h stroke: color },
                    Line{ startY: min endY: max stroke: color },
                    Line{ startY: min  endX: -h endY: min + h stroke: color },
                    Line{ startY: min  endX:  h endY: min + h stroke: color },

                ]
              }
              
//              Group{
//                  scaleY: -1
//                  content: content
//              }

            ]
      }
    }
    
}


