
varying vec3 normal;
varying float fogFactor;

void main() {
	normal = normalize(gl_NormalMatrix*gl_Normal);
	gl_FrontColor = gl_Color;
	vec4 pos = gl_ModelViewMatrix*gl_Vertex;
	gl_Position = ftransform();

	gl_FogFragCoord = length(pos.xyz);
	fogFactor = clamp((gl_Fog.end-gl_FogFragCoord)*gl_Fog.scale, 0.0, 1.0);
}