//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
sampler2D input : register(s0);
float4 main(float2 uv : TEXCOORD) : COLOR 
{ 
	float offset = 0.002;
	float scale = 1.6f;
	float scale2 = scale*0.5;
	
    float4 OrigColor;
    OrigColor = tex2D (input, uv.xy);
		float a = (OrigColor.r + OrigColor.b + OrigColor.g + OrigColor.a*1.2);
		// a *= 7;
		// a = clamp(a, 0, 1);

		float asafe = a;
		OrigColor = OrigColor * (a*a)*1.3;
		OrigColor.a = a*0.85;
		
		
    return OrigColor;
}


//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique Basic
{
    pass P0
    {          
        VertexShader = null;
        PixelShader  = compile ps_2_0 main();
    }
}
