uniform sampler2DShadow shadowMap;
uniform sampler2D tex;
varying vec4 shadowTexCoord;

varying vec3 eyeVec;
varying vec3 lightDir;
varying vec3 normal;

void main(void)
{
	vec4 final_color = 
	(gl_FrontLightModelProduct.sceneColor * gl_FrontMaterial.ambient) + 
	(gl_LightSource[0].ambient * gl_FrontMaterial.ambient);
							
	vec3 N = normalize(normal);
	vec3 L = normalize(lightDir);
	
	float lambertTerm = dot(N,L);
	
	if(lambertTerm > 0.0)
	{
		final_color += gl_LightSource[0].diffuse * 
		               gl_FrontMaterial.diffuse * 
					   lambertTerm;	
		
		vec3 E = normalize(eyeVec);
		vec3 R = reflect(-L, N);
		float specular = pow( max(dot(R, E), 0.0), 
		                 gl_FrontMaterial.shininess );
		final_color += gl_LightSource[0].specular * 
		               gl_FrontMaterial.specular * 
					   specular;	
	}

	vec4 texas;
	for(float x=-1.0; x <= 1.0; x++) {
		for(float y=-1.0; y <= 1.0; y++) {
			texas += shadow2DProj(shadowMap, shadowTexCoord + vec4(0.06*x, 0.06*y, .0, .0));
		}
	}
	texas /= 9.0;
	
	
	
//	float shadeVal = (shadow2DProj(shadowMap, shadowTexCoord).r < 1.0? .5: 1.0);
	gl_FragColor = texas * final_color * texture2D(tex, gl_TexCoord[0].xy);
}