uniform sampler2D bloomTex0;
uniform sampler2D bloomTex1;
uniform sampler2D bloomTex2;
uniform sampler2D bloomTex3;
varying vec2 bloomCoords;
float bloomBlurIndex = .002;

vec4 bloomContrast(in vec4 color) {
	float c = (color.r + color.g + color.b + color.a );
	c -= 2.0;
	clamp(c, .0, 1.0);
	return c * color; 
}

void gaussBlur(inout vec4 result, in vec2 coord, in sampler2D bloomTex, in float lod) {
	result += .0625 * bloomContrast(texture2D(bloomTex, vec2(coord.s - lod * bloomBlurIndex, coord.t + lod * bloomBlurIndex)));
	result += .125 * bloomContrast(texture2D(bloomTex, vec2(coord.s, coord.t + lod * bloomBlurIndex)));
	result += .0625 * bloomContrast(texture2D(bloomTex, vec2(coord.s + lod * bloomBlurIndex, coord.t + lod * bloomBlurIndex)));
	result += .125 * bloomContrast(texture2D(bloomTex, vec2(coord.s - lod * bloomBlurIndex, coord.t)));
	result += .25 * bloomContrast(texture2D(bloomTex, vec2(coord.s, coord.t)));
	result += .125 * bloomContrast(texture2D(bloomTex, vec2(coord.s + lod * bloomBlurIndex, coord.t)));
	result += .625 * bloomContrast(texture2D(bloomTex, vec2(coord.s - lod * bloomBlurIndex, coord.t - lod * bloomBlurIndex)));
	result += .125 * bloomContrast(texture2D(bloomTex, vec2(coord.s, coord.t - lod * bloomBlurIndex)));
	result += .625 * bloomContrast(texture2D(bloomTex, vec2(coord.s + lod * bloomBlurIndex, coord.t - lod * bloomBlurIndex)));
}

void bloom(inout vec4 color, in vec2 coord) {
	gaussBlur(color, coord, bloomTex0, 1.0);
	gaussBlur(color, coord, bloomTex1, 2.0);
	gaussBlur(color, coord, bloomTex2, 4.0);
	gaussBlur(color, coord, bloomTex3, 8.0);
}


void main() {
	vec4 color = vec4(0.0);
	bloom(color, bloomCoords);
	gl_FragColor = .2* color;
}