uniform float time;
uniform float ramp;
uniform sampler2D texture;

vec4 deform(vec2 st, float time, float ramp)
{
	float x = -1.0 + 2.0 * st.s;
	float y = -1.0 + 2.0 * st.t;
	
	float r = sqrt(x * x + y * y);
	float a = atan(y, x);
	
	a += time;
	r *= min(time, 1.5);

	// 3. 6 star warp
	r *= 0.75 * (x * cos(a + y) + y * sin(a + time));
	
	float u = r * cos(a);
	float v = r * sin(a);

	return vec4(u, v, 0.0, 0.0);
}

void main(void)
{
	//gl_TexCoord[0] = gl_MultiTexCoord0;

	gl_TexCoord[0] = deform(gl_MultiTexCoord0, time, ramp);
	gl_Position = ftransform();
}