uniform float time;
uniform float ramp;
uniform sampler2D texture;

vec4 deform(vec2 st, float time, float ramp)
{
	float x = -1.0 + 2.0 * st.s;
	float y = -1.0 + 2.0 * st.t;
	
	float r = sqrt(x * x + y * y);
	float a = atan(y, x);
	
	//r += (x);
	//r *= 0.75 * (x * cos(a + y) + y * sin(a + time));
	//a += time * (x * y) / 3;
	
	//r *= 1.0 * (x + y);
	
	a -= time;
	r *= lerp(0.0, 1.5, ramp);
	//r *= min(time, 0.75);
	//r *= (ramp * time);
	
	//r *= min(time, 1.25 * (1.0 - ramp));

	// 1. Plaid
	//r = r;
	
	// 2. X center feedback
	//r *= 1.0 * (x + y);
	
	// 3. 6 star warp
	//r *= 0.75 * (x * cos(a + y) + y * sin(a + time));
	
	// 4. Curved lines
	//a -= time * (x * y) / 3;
	
	//a += r * 1.5;
		
	float u = r * cos(a);
	float v = r * sin(a);
	
	return vec4(u, v, 0.0, 0.0);
}

void main(void)
{
	//gl_TexCoord[0] = gl_MultiTexCoord0;
	vec2 st = gl_MultiTexCoord0.st;

	gl_TexCoord[0] = deform(st, time, ramp);
	gl_Position = ftransform();
}