
#ifndef NUM_LIGHTS
	#define NUM_LIGHTS 3
#endif

varying vec3 normal;
varying vec3 lightDir[NUM_LIGHTS];
varying vec3 eye;
varying float camdot;

void main() {
	gl_TexCoord[0] = gl_TextureMatrix[0]*gl_MultiTexCoord0;

	vec4 tangent = gl_MultiTexCoord7;

	vec3 n = normalize(gl_NormalMatrix*gl_Normal);
	vec3 t = normalize(gl_NormalMatrix*tangent.xyz);
	vec3 b = cross(n, t)*tangent.a;

	vec4 pos = gl_ModelViewMatrix*gl_Vertex;

/*	camdot = 1.0-dot(n, normalize(-pos.xyz));
	camdot = camdot*camdot*camdot*2.0;*/
	camdot = -pos.xyz;

	vec3 tmpVec;
	for (int i = 0; i < NUM_LIGHTS; i++) {
		tmpVec = vec3(gl_LightSource[i].position-pos);

		lightDir[i].x = dot(tmpVec, t);
		lightDir[i].y = dot(tmpVec, b);
		lightDir[i].z = dot(tmpVec, n);
	}

	tmpVec = -pos.xyz;
	eye.x = dot(tmpVec, t);
	eye.y = dot(tmpVec, b);
	eye.z = dot(tmpVec, n);

	normal = n;

	gl_Position = ftransform();
}
