#include "_shared.fx"

float4x4 wMatrix 	: World
<
	string UIWidget="None";
>;

struct VS_INPUT
{
    float3 Position 	: POSITION;
	uint instance		: SV_InstanceID;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	uint split : TEXTURE0;
};

struct GS_OUTPUT
{
    float4 Position	: SV_POSITION;
	uint rtIndex : SV_RenderTargetArrayIndex;
};

struct PS_OUTPUT
{
	float depth : SV_Depth;
};

DepthStencilState EnableDepth
{
    DepthEnable = TRUE;
    DepthWriteMask = ALL;
    DepthFunc = LESS_EQUAL;
	StencilEnable = false;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    float4x4 wvpMatrix = mul(mul(wMatrix,lvMatrix),pMatrices[In.instance]);
    Out.Position = mul(float4(In.Position,1.0f), wvpMatrix);
	Out.split = In.instance;
    return Out;
}

[maxvertexcount(3)]
void RenderSceneGS( triangle VS_OUTPUT In[3], inout TriangleStream<GS_OUTPUT> triStream )
{
	GS_OUTPUT Out;
	Out.rtIndex = In[0].split;
	Out.Position = In[0].Position;
	triStream.Append(Out);
	Out.Position = In[1].Position;
	triStream.Append(Out);
	Out.Position = In[2].Position;
	triStream.Append(Out);
	triStream.RestartStrip();
}

/*PS_OUTPUT RenderScenePS( GS_OUTPUT In )
{
	PS_OUTPUT Out;
	float screenDepth = In.Position.z/In.Position.w;
	Out.depth = exp(-exp_c*screenDepth);
	return Out;
};*/

technique10 RenderDepth
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( CompileShader( gs_4_0, RenderSceneGS() ) );
        //SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		SetPixelShader( NULL );

        SetDepthStencilState( EnableDepth, 0 );
		SetRasterizerState( NotMultisampled );
    }
}