#include "_shared.fx"

float4x4 wvpMatrix 	: WorldViewProjection;
Texture2D circle;
struct VS_INPUT
{
    float3 vPos 	: POSITION;
	float3 uvCoord 	: TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float3 uvCoord	: TEXCOORD0;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
    Out.Position = mul(float4(In.vPos,1.0f), wvpMatrix);
	float coef = In.uvCoord.z+12.7f-time*0.16f;
	Out.uvCoord = float3(In.uvCoord.x, In.uvCoord.y, saturate(exp(-30.0f*abs(coef))) );
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	Out.finalColor = circle.Sample(LinearSampler,float2(In.uvCoord.x,In.uvCoord.y)).a*In.uvCoord.z;
	
    return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( NoDepth, 0 );
		SetBlendState( AdditiveBlending, float4(0,0,0,0), 0xffffffff );
    }
}